<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Region;
use App\Models\Prefecture;
use App\Models\City;

class ImportLocations extends Command
{
    protected $signature = 'import:locations {file}';

    //  php artisan import:locations storage/app/All Cities in Japan - Tuan.csv

    protected $description = 'Import regions, prefectures, and cities from CSV file';

    public function handle()
    {
        $filePath = $this->argument('file');

        if (!file_exists($filePath)) {
            $this->error('File not found!');
            return;
        }

        $file = fopen($filePath, 'r');
        $headers = fgetcsv($file);
        $indexes = array_flip($headers);

        $regions = [];
        $prefectures = [];
        $cities = [];

        while (($data = fgetcsv($file)) !== FALSE) {
            $region_jp = $data[$indexes['region_jp']] ?? null;
            $region_en = $data[$indexes['region_en']] ?? null;
            $pref_jp   = $data[$indexes['pref_jp']] ?? null;
            $pref_en   = $data[$indexes['pref_en']] ?? null;
            $city_jp   = $data[$indexes['city_jp']] ?? null;
            $city_en   = $data[$indexes['city_en']] ?? null;
            $city_type = $data[$indexes['city_type']] ?? null;

            // Insert Region
            if (!isset($regions[$region_en])) {
                $region = Region::firstOrCreate(['eng_name' => $region_en, 'jap_name' => $region_jp]);
                $regions[$region_en] = $region->id;
            }

            // Insert Prefecture
            $regionId = $regions[$region_en];
            if (!isset($prefectures[$pref_en])) {
                $prefecture = Prefecture::firstOrCreate([
                    'eng_name' => $pref_en,
                    'jap_name' => $pref_jp,
                    'region_id' => $regionId
                ]);
                $prefectures[$pref_en] = $prefecture->id;
            }

            // Insert City
            $prefectureId = $prefectures[$pref_en];
            if (!isset($cities[$city_en])) {
                City::firstOrCreate([
                    'eng_name' => $city_en,
                    'jap_name' => $city_jp,
                    'city_type' => $city_type,
                    'prefecture_id' => $prefectureId
                ]);
                $cities[$city_en] = true;
            }
        }

        fclose($file);
        $this->info('Data imported successfully!');
    }
}
