<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ContractMail extends Mailable
{
    use Queueable, SerializesModels;

    public $subject;
    public $body;
    public $title;
    public $pdfPath;

    public function __construct($subject, $body, $title, $pdfPath)
    {
        $this->subject = $subject;
        $this->body = $body;
        $this->title = $title;
        $this->pdfPath = $pdfPath;
    }

    public function build()
    {
        return $this->subject($this->subject)
                    ->view('emails.contract')
                    ->with([
                        'body' => $this->body,
                        'title' => $this->title
                    ])
                    ->attach(storage_path('app/public/' . $this->pdfPath), [
                        'as' => 'Contract.pdf',
                        'mime' => 'application/pdf',
                    ]);
    }
}
