<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tour_exception_commissions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('channel_commission_id');
            $table->unsignedBigInteger('tour_id');
            $table->string('title')->default('Tour Exception');
            $table->integer('commission');
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('channel_commission_id')->references('id')->on('channel_commissions')->onDelete('cascade');
            $table->foreign('tour_id')->references('id')->on('tours')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tour_exception_commissions');
    }
};
