<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('tour_guides', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('region_id');
            $table->unsignedBigInteger('prefecture_id');
            $table->unsignedBigInteger('city_id');
            $table->string('station');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('japanese_name');
            $table->string('email')->unique();
            $table->string('phone');
            $table->date('dob');
            $table->string('gender');
            $table->string('interpreter_license');
            $table->string('license_number')->nullable();
            $table->text('certifications')->nullable();
            $table->integer('english_fluency');
            $table->json('other_languages')->nullable();
            $table->text('job_experience');
            $table->string('years_of_experience');
            $table->string('number_of_tours');
            $table->json('guide_areas')->nullable();
            $table->json('type_of_tours');
            $table->string('type_of_tours_other')->nullable();
            $table->string('how_heard');
            $table->string('referred_person')->nullable();
            $table->string('how_heard_other')->nullable();
            $table->text('availability');
            $table->integer('status')->default(2);
            $table->string('position')->default('Tour Guide');
            $table->timestamps();

            $table->foreign('region_id')->references('id')->on('regions')->onDelete('cascade');
            $table->foreign('prefecture_id')->references('id')->on('prefectures')->onDelete('cascade');
            $table->foreign('city_id')->references('id')->on('cities')->onDelete('cascade');
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tour_guides');
    }
};
