<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tour_guides', function (Blueprint $table) {
            $table->text('work_area')->nullable();
            $table->text('address')->nullable();
            $table->string('lat_long')->nullable();
            $table->string('private_vehicle')->nullable();
            $table->string('car_type')->nullable();
            $table->integer('capacity')->nullable();
            $table->string('invoice_registration')->nullable();
            $table->string('invoice_registration_number')->nullable();
            $table->text('bank_information')->nullable();
            $table->text('experience_area')->nullable();
            $table->text('notes')->nullable();
            $table->string('interviewed_by')->nullable();
            $table->text('interiewer_observations')->nullable();
            $table->string('english_fluency_rating')->nullable();
            $table->string('communication_preferred')->nullable();
            $table->string('recording_of_interview')->nullable();
            $table->integer('starting_rate')->nullable();
            $table->json('guide_fee')->nullable();
            $table->json('important_notes')->nullable();
            $table->text('comment')->nullable();
            $table->string('line_user_id')->nullable();
            $table->string('line_group_id')->nullable();
            $table->string('contract')->nullable();
            $table->datetime('sign_date')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tour_guides', function (Blueprint $table) {
            $table->dropColumn(['work_area', 'address', 'lat_long', 'private_vehicle', 'car_type', 'capacity', 'invoice_registration', 'invoice_registration_number', 'bank_information', 'experience_area', 'notes', 'interviewed_by', 'interiewer_observations', 'english_fluency_rating', 'communication_preferred', 'recording_of_interview', 'starting_rate', 'guide_fee', 'important_notes', 'comment', 'line_user_id', 'line_group_id', 'contract', 'sign_date']);
        });
    }
};
