<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class OtherLanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $csvFile = fopen(base_path("storage/app/languages.csv"), "r");

        // Skip CSV header
        fgetcsv($csvFile);

        while (($data = fgetcsv($csvFile, 1000, ",")) !== FALSE) {
            DB::table('other_languages')->insert([
                'name' => $data[0],
                'code' => $data[1]
            ]);
        }

        fclose($csvFile);
    }
}
