<x-admin-layout>
    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <h1 class="text-2xl font-bold mb-4">Permissions List</h1>

        @foreach ($modules as $module => $permissions)
            <div x-data="{ open: false }" class="mb-4 border border-gray-300 rounded-lg">
                <!-- Module Header (Dropdown Toggle) -->
                <div @click="open = !open"
                    class="flex justify-between items-center p-4 bg-gray-100 dark:bg-gray-700 cursor-pointer rounded-t-lg">
                    <span class="text-lg font-semibold text-gray-900 dark:text-gray-100">{{ ucfirst($module) }}</span>

                    <!-- Dropdown Icon -->
                    <svg x-show="!open" class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor"
                        viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                    <svg x-show="open" class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor"
                        viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7"></path>
                    </svg>
                </div>

                <!-- Dropdown Content -->
                <div x-show="open" class="p-4 bg-gray-50 dark:bg-gray-800">
                    @foreach ($permissions as $permission)
                        <div class="flex justify-between items-center p-2 border-b border-gray-300">
                            <span class="text-gray-800 dark:text-gray-200">{{ $permission->name }}</span>

                            <!-- Action Buttons for Every Module -->
                            <div class="space-x-4">
                                <a href="{{ route('admin.permissions.show', $permission) }}" class="text-blue-500 hover:underline">View</a>
                                <a href="{{ route('admin.permissions.edit', $permission) }}" class="text-green-500 hover:underline">Edit</a>
                                <button type="button" class="text-red-500 hover:underline"
                                    onclick="confirm('Are you sure?') ? document.getElementById('delete-{{ $permission->id }}').submit() : ''">
                                    Delete
                                </button>
                                <form id="delete-{{ $permission->id }}"
                                    action="{{ route('admin.permissions.destroy', $permission) }}"
                                    method="POST" style="display: none;">
                                    @csrf @method('DELETE')
                                </form>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach
    </div>
</x-admin-layout>
