<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Tour Guide Details</h1>
    </x-slot>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Basic Information</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">First Name: <span class="font-medium">{{ $tourGuide->first_name }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Last Name: <span class="font-medium">{{ $tourGuide->last_name }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Japanese Name: <span class="font-medium">{{ $tourGuide->japanese_name }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Email: <span class="font-medium">{{ $tourGuide->email }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Phone: <span class="font-medium">{{ $tourGuide->phone }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">DOB: <span class="font-medium">{{ $tourGuide->dob }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Gender: <span class="font-medium">{{ ucfirst($tourGuide->gender) }}</span></p>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Location Details</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Region: <span class="font-medium">{{ $tourGuide->region->eng_name ?? 'N/A' }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Prefecture: <span class="font-medium">{{ $tourGuide->prefecture->eng_name ?? 'N/A' }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">City: <span class="font-medium">{{ $tourGuide->city->eng_name ?? 'N/A' }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Station: <span class="font-medium">{{ $tourGuide->station }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Address: <span class="font-medium">{{ $tourGuide->address }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Lat/Long: <span class="font-medium">{{ $tourGuide->lat_long }}</span></p>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Guide Experience</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Years of Experience: <span class="font-medium">{{ $tourGuide->years_of_experience }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Number of Tours: <span class="font-medium">{{ $tourGuide->number_of_tours }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Job Experience: <span class="font-medium">{{ $tourGuide->job_experience }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">English Fluency: <span class="font-medium">{{ $tourGuide->english_fluency }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Other Languages:
                @php
                    $selectedLanguages = json_decode($tourGuide->other_languages, true) ?? [];
                @endphp
                @if (!empty($selectedLanguages))
                    <span class="font-medium">
                        {{ implode(', ', collect($other_languages)->whereIn('id', $selectedLanguages)->pluck('name')->toArray()) }}
                    </span>
                @else
                    <span class="text-gray-500">No other languages</span>
                @endif
            </p>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Tour Details</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Types of Tours:
                <span class="font-medium">
                    {{ implode(', ', json_decode($tourGuide->type_of_tours, true) ?? []) }}
                </span>
            </p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Tour Guide Areas:</p>
            <ul class="mt-2 list-disc list-inside text-gray-600 dark:text-gray-400">
                @foreach (json_decode($tourGuide->guide_areas, true) ?? [] as $area)
                    <li>
                        <span class="font-medium">Region:</span> {{ getRegionName($area['region']) }},
                        <span class="font-medium">Prefecture:</span> {{ getPrefectureName($area['prefecture']) }},
                        <span class="font-medium">Cities:</span>
                        {{ implode(', ', array_map('getCityName', $area['cities'])) }}
                    </li>
                @endforeach
            </ul>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Experience Area: <span class="font-medium">{{ $tourGuide->experience_area }}</span></p>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Vehicle Details</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Private Vehicle: <span class="font-medium">{{ $tourGuide->private_vehicle ? 'Yes' : 'No' }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Car Type: <span class="font-medium">{{ $tourGuide->car_type }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Capacity: <span class="font-medium">{{ $tourGuide->capacity }}</span></p>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Financial Information</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Invoice Registration: <span class="font-medium">{{ $tourGuide->invoice_registration }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Invoice Number: <span class="font-medium">{{ $tourGuide->invoice_registration_number }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Bank Info: <span class="font-medium">{{ $tourGuide->bank_information }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Starting Rate: <span class="font-medium">{{ $tourGuide->starting_rate }}</span></p>
            <!-- Guide Fee Table -->
            <div class="mt-4">
                <label class="block text-gray-700 font-medium mb-2">Guide Fee (Hourly Rate)</label>
                <table class="w-full border-collapse border">
                    <thead>
                        <tr class="bg-green-300">
                            <th class="border p-2"># of People</th>
                            <th class="border p-2">7 - 8+ hours</th>
                            <th class="border p-2">5 - 6 hours</th>
                            <th class="border p-2">1 - 4 hours</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                        $fees = is_string($tourGuide->guide_fee) ? json_decode($tourGuide->guide_fee, true) : $tourGuide->guide_fee;
                        @endphp
                        <tr>
                            <td class="border p-2 bg-green-200">1 - 6 people</td>
                            <td class="border p-2">{{ $fees[1] ?? '-' }}</td>
                            <td class="border p-2">{{ $fees[101] ?? '-' }}</td>
                            <td class="border p-2">{{ $fees[201] ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="border p-2 bg-green-200">7 - 15 people</td>
                            <td class="border p-2">{{ $fees[301] ?? '-' }}</td>
                            <td class="border p-2">{{ $fees[401] ?? '-' }}</td>
                            <td class="border p-2">{{ $fees[501] ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="border p-2 bg-green-200">16 - 27 people</td>
                            <td class="border p-2">{{ $fees[601] ?? '-' }}</td>
                            <td class="border p-2">{{ $fees[701] ?? '-' }}</td>
                            <td class="border p-2">{{ $fees[801] ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td class="border p-2 bg-green-200">28+ people</td>
                            <td class="border p-2">{{ $fees[901] ?? '-' }}</td>
                            <td class="border p-2">{{ $fees[1001] ?? '-' }}</td>
                            <td class="border p-2">{{ $fees[1101] ?? '-' }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <hr class="m-4">
        <div class="mb-4">
            <h2 class="ml-2 text-xl font-semibold text-gray-900 dark:text-gray-100">Contract & Documents</h2>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Contract:
                <a href="{{ asset($tourGuide->contract) }}" class="text-indigo-600 dark:text-indigo-400 hover:underline">
                    View Contract
                </a>
            </p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Interview By:
                @php
                    $interviewer = collect($managers)->firstWhere('id', $tourGuide->interviewed_by ?? null);
                @endphp
                @if ($interviewer)
                    <span class="font-medium">{{ $interviewer['name'] }}</span>
                @else
                    <span class="text-gray-500">No Interview By</span>
                @endif
            </p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Interview Date: <span class="font-medium">{{ $tourGuide->interview_date }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Interview's Observation: <span class="font-medium">{{ $tourGuide->interiewer_observations }}</span></p>
            <p class="mt-2 text-gray-600 dark:text-gray-400">Sign Date: <span class="font-medium">{{ $tourGuide->sign_date }}</span></p>
        </div>

        <div class="flex items-center justify-between mt-4">
            <a href="{{ route('admin.tour-guides.index') }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                Back to Tour Guide List
            </a>
        </div>
    </div>
</x-admin-layout>
