<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Create Tour</h1>
    </x-slot>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <form action="{{ route('admin.users.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

     <!-- Grid Layout with 6 Columns -->
     <div class="grid grid-cols-1 gap-6 mt-4 sm:grid-cols-2">
            <!-- First Name Field -->
                <div>
                    <label for="bokun_id" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Bokun ID</label>
                        <input  type="text" name="bokun_id" id="bokun_id" required
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Last Name Field -->
                <div>
                    <label for="bokun_title" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Bokun Title</label>
                        <input type="text" name="bokun_title" id="bokun_title" required
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Japanese Name Field -->
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Tour Name</label>
                        <input type="text" name="name" id="name" required
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Time Field -->
                <div>
                    <label for="time" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Time</label>
                    <div class="relative mt-2">
                        <select id="time" name="time"
                            class="w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 outline-gray-300 focus:outline-2 focus:outline-indigo-600 sm:text-sm">
                            <option value="custom">Custom</option>
                            <option value="fixed">Fixed</option>
                        </select>
                    </div>
                </div>

                <!-- Line Name Field -->
                <div>
                    <label for="line_name" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Line Name</label>
                        <input type="text" name="line_name" id="line_name"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Login Email Field -->
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Login Email</label>

                        <input type="email" name="email" id="email" required
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Operating Location Field -->
                <div>
                    <label for="operating_location" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Operating Location</label>
                        <input type="text" name="operating_location" id="operating_location"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Personal Email Field -->
                <div>
                    <label for="personal_email" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Personal Email (Optional)</label>
                        <input type="email" name="personal_email" id="personal_email"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Gender Field -->
                <div>
                    <label for="gender" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Gender</label>
                    <div class="relative mt-2">
                        <select id="gender" name="gender"
                            class="w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 outline-gray-300 focus:outline-2 focus:outline-indigo-600 sm:text-sm">
                            <option value="male">Male</option>
                            <option value="female">Female</option>
                        </select>
                    </div>
                </div>

                <!-- Age Field -->
                <div>
                    <label for="age" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Age</label>
                        <input type="number" min="1" max="100" name="age" id="age" class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Birth Date -->
                <div>
                    <label for="birth_date" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Birth Date </label>
                    <input type="date" name="birth_date" id="birth_date"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Residence Field -->
                <div>
                    <label for="residence" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Residence</label>
                        <input type="text" name="residence" id="residence"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Line Group Chat Field -->
                <div>
                    <label for="line_group_chat" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Line group chat </label>
                    <input type="text" name="line_group_chat" id="line_group_chat"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Role Field -->
                <div>
                    <label for="role" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Roles</label>
                    <div class="relative mt-2">
                        <select id="role" name="role_id"
                            class="w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 outline-gray-300 focus:outline-2 focus:outline-indigo-600 sm:text-sm">
                            @foreach ($roles as $role)
                                <option value="{{ $role->id }}" >
                                    {{ $role->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <!-- Address Field -->
                <div>
                    <label for="address" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Address</label>
                        <textarea name="address" id="address"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50"></textarea>
                </div>

                <!-- Other Address Field -->
                <div>
                    <label for="other_address" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Other Address</label>
                        <textarea name="other_address" id="other_address"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50"></textarea>
                </div>

                <!-- Details Field -->
                <div>
                    <label for="detail" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Detail (Optional)</label>
                        <textarea name="detail" id="detail"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50"></textarea>
                </div>

                <!-- Bank info Field -->
                <div>
                    <label for="bank_info" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Bank info </label>
                    <textarea name="bank_info" id="bank_info"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50"></textarea>
                </div>

                <!-- Working Hours Field -->
                <div>
                    <label for="working_hours" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Working Hours </label>
                    <textarea name="working_hours" id="working_hours"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50"></textarea>
                </div>


                <!-- Working Hours Other Field -->
                <div>
                    <label for="working_hours_other" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Working Hours Other</label>
                    <textarea name="working_hours_other" id="working_hours_other"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50"></textarea>
                </div>

                <!-- other Field -->
                <div>
                    <label for="other" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Other </label>
                    <textarea name="other" id="other"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50"></textarea>
                </div>

                <!-- Started On Date -->
                <div>
                    <label for="started_on" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Started On </label>
                    <input type="date" name="started_on" id="started_on"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- User Image Field -->
                <div>
                    <div class="col-span-full">
                        <label class="block text-sm font-medium text-gray-900">User Photo</label>
                        <div class="flex flex-col items-center p-6 mt-2 border-2 border-gray-400 border-dashed rounded-lg">
                                <img id="imagePreview" class="hidden w-24 h-24 rounded-full" />
                            <input id="user_image" name="user_image" type="file" accept="image/*" class="hidden">
                            <label for="user_image"
                            class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white transition duration-150 ease-in-out bg-gray-800 border border-transparent rounded-md dark:bg-gray-200 dark:text-gray-800 hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800">
                                Upload a file
                            </label>
                            <p class="mt-1 text-xs text-gray-600">PNG, JPG, GIF up to 10MB</p>
                        </div>
                    </div>

                </div>


                <!-- Work Email Section -->
                <div>
                    <label for="work_email" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Work Email</label>
                    <div id="work-email-container">
                        <div class="flex items-center space-x-4 work-email-row">
                            <input type="email" name="work_email[]" class="block w-full mt-1 border-gray-300 rounded-md shadow-sm">
                            <button type="button" class="px-2 py-1 text-white bg-green-500 rounded-md add-work-email">+</button>
                        </div>
                    </div>
                </div>

                <!-- Share Email Section -->
                <div>
                    <label for="share_email" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Share Email</label>
                    <div id="share-email-container">
                        <div class="flex items-center space-x-4 share-email-row">
                            <input type="email" name="share_email[]" class="block w-full mt-1 border-gray-300 rounded-md shadow-sm">
                            <button type="button" class="px-2 py-1 text-white bg-green-500 rounded-md add-share-email">+</button>
                        </div>
                    </div>
                </div>

                <!-- Phone Number Section -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Phone Number</label>
                    <div id="phone-number-container">
                        <div class="flex items-center space-x-4 phone-number-row">
                            <input type="text" name="phone_number[]" class="w-full mt-1 border-gray-300 rounded-md shadow-sm">
                            <select name="phone_number_type[]" class="mt-1 border-gray-300 rounded-md shadow-sm">
                                <option value="Personal">Personal</option>
                                <option value="JA Mobile">JA Mobile</option>
                                <option value="JA Booking Phone">JA Booking Phone</option>
                                <option value="JA Global">JA Global</option>
                                <option value="Office Phone Number">Office Phone Number</option>
                                <option value="Bookings Phone Number">Bookings Phone Number</option>
                            </select>
                            <button type="button" class="px-2 py-1 text-white bg-green-500 rounded add-phone">+</button>
                        </div>
                    </div>
                </div>

                    <!-- Local Number Section -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Local Number</label>
                        <div id="local-number-container">
                            <div class="flex items-center space-x-4 local-number-row">
                                <input type="text" name="local_number[]" class="w-full mt-1 border-gray-300 rounded-md shadow-sm">
                                <select name="local_number_type[]" class="mt-1 border-gray-300 rounded-md shadow-sm">
                                    <option value="Personal">Personal</option>
                                    <option value="JA Mobile">JA Mobile</option>
                                    <option value="JA Booking Phone">JA Booking Phone</option>
                                    <option value="JA Global">JA Global</option>
                                    <option value="Office Phone Number">Office Phone Number</option>
                                    <option value="Bookings Phone Number">Bookings Phone Number</option>
                                </select>
                                <button type="button" class="px-2 py-1 text-white bg-green-500 rounded add-local">+</button>
                            </div>
                        </div>
                    </div>

            </div>
            <div class="flex items-center justify-between mt-6">
                <a href="{{ route('admin.users.index') }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                    Back to Users List
                </a>
                <button type="submit" class="px-4 py-2 text-white bg-indigo-600 rounded-md">
                    Update User
                </button>
            </div>

        </form>
    </div>
    <script>
        // Work Email Add & Remove Logic
        document.querySelector(".add-work-email").addEventListener("click", function () {
            let container = document.getElementById("work-email-container");
            let newField = document.createElement("div");
            newField.classList.add("flex", "items-center", "space-x-4", "work-email-row");
            newField.innerHTML = `
                <input type="email" name="work_email[]" class="block w-full mt-1 border-gray-300 rounded-md shadow-sm">
                <button type="button" class="px-2 py-1 text-white bg-red-500 rounded-md remove-work-email">-</button>
            `;
            container.appendChild(newField);
        });

        document.getElementById("work-email-container").addEventListener("click", function (event) {
            if (event.target.classList.contains("remove-work-email")) {
                event.target.parentElement.remove();
            }
        });

        // Share Email Add & Remove Logic
        document.querySelector(".add-share-email").addEventListener("click", function () {
            let container = document.getElementById("share-email-container");
            let newField = document.createElement("div");
            newField.classList.add("flex", "items-center", "space-x-4", "share-email-row");
            newField.innerHTML = `
                <input type="email" name="share_email[]" class="block w-full mt-1 border-gray-300 rounded-md shadow-sm">
                <button type="button" class="px-2 py-1 text-white bg-red-500 rounded-md remove-share-email">-</button>
            `;
            container.appendChild(newField);
        });

        document.getElementById("share-email-container").addEventListener("click", function (event) {
            if (event.target.classList.contains("remove-share-email")) {
                event.target.parentElement.remove();
            }
        });

        document.addEventListener("DOMContentLoaded", function () {
            // Function to add a new phone number row
            function addRow(containerId, rowClass, nameField, selectField) {
                let container = document.getElementById(containerId);
                let newRow = document.createElement("div");
                newRow.classList.add("flex", "items-center", "space-x-4", rowClass);
                newRow.innerHTML = `
                    <input type="text" name="${nameField}" class="w-full mt-1 border-gray-300 rounded-md shadow-sm">
                    <select name="${selectField}" class="mt-1 border-gray-300 rounded-md shadow-sm">
                        <option value="Personal">Personal</option>
                        <option value="JA Mobile">JA Mobile</option>
                        <option value="JA Booking Phone">JA Booking Phone</option>
                        <option value="JA Global">JA Global</option>
                        <option value="Office Phone Number">Office Phone Number</option>
                        <option value="Bookings Phone Number">Bookings Phone Number</option>
                    </select>
                    <button type="button" class="px-2 py-1 text-white bg-red-500 rounded remove-row">-</button>
                `;
                container.appendChild(newRow);

                // Add event listener to remove button
                newRow.querySelector(".remove-row").addEventListener("click", function () {
                    newRow.remove();
                });
            }

            // Phone Number - Add Row
            document.querySelector(".add-phone").addEventListener("click", function () {
                addRow("phone-number-container", "phone-number-row", "phone_number[]", "phone_number_type[]");
            });

            // Local Number - Add Row
            document.querySelector(".add-local").addEventListener("click", function () {
                addRow("local-number-container", "local-number-row", "local_number[]", "local_number_type[]");
            });
        });
    </script>
</x-admin-layout>

