<!DOCTYPE html>
<html lang="<?php echo e($page->language ?? 'en'); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <meta http-equiv="x-ua-compatible" content="ie=edge">
        <meta name="referrer" content="always">

        <title><?php echo e(config('app.name', 'Portal')); ?></title>

        <!-- Bootstrap CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

        <link href="https://fonts.googleapis.com/css2?family=Urbanist:wght@400;500;600;700&display=swap" rel="stylesheet">

        <!-- Bootstrap JS (for modals) -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

        <!-- jQuery (must be included first) -->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

        <!-- Select2 CSS -->
        <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet">

        <!-- intl-tel-input CSS -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/css/intlTelInput.css"/>

        <!-- Select2 JavaScript -->
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

        <!-- intl-tel-input JS -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput.min.js"></script>

        <!-- Favicon -->
        <link rel="icon" type="image/png" src="<?php echo e(asset('img/logo.png')); ?>">

        <!-- Alternative for .ico -->
        <link rel="shortcut icon" src="<?php echo e(asset('img/logo.png')); ?>">

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <style>
        .select2-container--default .select2-results__option {
            font-size: 0.875rem; /* text-sm */
            padding: 0.5rem;
        }

        .select2-container--default .select2-results__option--highlighted {
            background-color: #8B8D98 !important; /* Tailwind indigo-600 */
            color: white !important;
        }
        .select2-container--default .select2-selection--single .select2-selection__rendered {
            font-size: 0.875rem;
            font-weight: 500;
            color:black !important;
        }
    </style>
    <body style="font-family: 'Urbanist', sans-serif;">
        <div x-data="{ sidebarOpen: false }" class="flex h-screen bg-gray-200 font-roboto">
            <?php echo $__env->make('layouts.admin.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="flex flex-col flex-1 overflow-hidden">
                <?php echo $__env->make('layouts.admin.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-100">
                    <div class="container px-6 py-8 mx-auto">
                        <?php echo e($slot); ?>

                    </div>
                </main>
            </div>
        </div>
    </body>
</html>
<?php /**PATH C:\xampp8.2\htdocs\Portal\resources\views/layouts/admin/master.blade.php ENDPATH**/ ?>