<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h1 class="text-2xl font-bold">Edit Tour Guide</h1>
     <?php $__env->endSlot(); ?>

    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md">
        <h2 class="mt-4 mb-4 text-xl font-semibold text-black leading-tight">General information</h2>
        <form action="<?php echo e(route('admin.tour-guides.update', $guide)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <?php if($errors->any()): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                    <strong class="font-bold">There were some errors:</strong>
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="grid grid-cols-2 gap-6"> <!-- Two-column grid -->

                <!-- Status Toggle Button -->
                    <div id="statusContainer" style="display: none;">  <!-- Initially Hidden -->
                        <label class="block text-sm font-medium text-gray-400 dark:text-gray-100">Status</label>
                        <div class="mt-2 flex items-center">
                            <!-- Hidden Input Field for Form Submission -->
                            <input type="hidden" name="status" id="statusInput" value="<?php echo e($guide->status); ?>">

                            <!-- Toggle Switch -->
                            <button type="button" id="toggleButton"
                                class="relative w-12 h-6 flex items-center rounded-full p-1 transition duration-300"
                                onclick="toggleStatus()">
                                <div id="toggleCircle"
                                    class="w-5 h-5 bg-white rounded-full shadow-md transform transition duration-300">
                                </div>
                            </button>
                            <span class="ml-3 text-sm text-gray-400 dark:text-gray-300" id="statusText"></span>
                        </div>
                    </div>


                <!-- Postion -->
                <div>
                    <label for="position" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Position <span class="text-red-500">*</span></label>
                    <select id="position" name="position" class="select2 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Please select a position</option>
                        <option value="Tour Guide" <?php echo e(old('position', $guide->position) == 'Tour Guide' ? 'selected' : ''); ?>>Tour Guide</option>
                        <option value="Tour Support" <?php echo e(old('position', $guide->position) == 'Tour Support' ? 'selected' : ''); ?>>Tour Support</option>
                        <option value="Photographer" <?php echo e(old('position', $guide->position) == 'Photographer' ? 'selected' : ''); ?>>Photographer</option>
                    </select>
                    <?php $__errorArgs = ['position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- First Name -->
                <div>
                    <label for="first_name" class="block text-sm font-medium text-gray-400 dark:text-gray-100">First Name</label>
                    <input type="text" id="first_name" name="first_name" value="<?php echo e(old('first_name', $guide->first_name)); ?>"
                        class="mt-1 block w-full border-gray-300 font-semibold text-sm rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>

                <!-- Last Name -->
                <div>
                    <label for="last_name" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Last Name</label>
                    <input type="text" id="last_name" name="last_name" value="<?php echo e(old('last_name', $guide->last_name)); ?>"
                        class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm  focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>

                <!-- Japanese Name -->
                <div>
                    <label for="japanese_name" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Japanese Name</label>
                    <input type="text" id="japanese_name" name="japanese_name" value="<?php echo e(old('japanese_name', $guide->japanese_name)); ?>"
                        class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm  focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>

                <!-- Gender -->
                <div>
                    <label for="gender" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Gender</label>
                    <select id="gender" name="gender" class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Select an option</option>
                        <option value="Male" <?php echo e(old('gender', $guide->gender) == 'Male' ? 'selected' : ''); ?>>Male</option>
                        <option value="Female" <?php echo e(old('gender', $guide->gender) == 'Female' ? 'selected' : ''); ?>>Female</option>
                    </select>
                </div>

                <!-- Birthdate -->
                <div>
                    <label for="dob" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Birthdate</label>
                    <input type="date" id="dob" name="dob" value="<?php echo e(old('dob', $guide->dob)); ?>"
                        class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>

                <!-- Email -->
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Email <span class="text-red-500">*</span></label>
                    <input type="text" id="email" name="email" value="<?php echo e(old('email', $guide->email)); ?>"
                        class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Phone -->
                <div>
                    <label for="phone" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Phone Number <span class="text-red-500">*</span></label>
                    <input type="tel" id="phone" name="phone" value="<?php echo e(old('phone', $guide->phone)); ?>"
                        class="mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm  focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Region -->
                <div>
                    <label for="region_id" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Region</label>
                    <select id="region_id" name="region_id" class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Select Region</option>
                        <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($region->id); ?>" <?php echo e($guide->region_id == $region->id ? 'selected' : ''); ?>>
                                <?php echo e($region->eng_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Prefecture -->
                <div>
                    <label for="prefecture_id" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Prefecture</label>
                    <select id="prefecture_id" name="prefecture_id" class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Select Prefecture</option>
                        <?php $__currentLoopData = $guide->region->prefectures ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prefecture): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($prefecture->id); ?>" <?php echo e($guide->prefecture_id == $prefecture->id ? 'selected' : ''); ?>>
                                <?php echo e($prefecture->eng_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- City -->
                <div>
                    <label for="city_id" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">City</label>
                    <select id="city_id" name="city_id" class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Select City</option>
                        <?php $__currentLoopData = $uide->prefecture->cities ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($city->id); ?>" <?php echo e($guide->city_id == $city->id ? 'selected' : ''); ?>>
                                <?php echo e($city->eng_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Station -->
                <div>
                    <label for="station" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Station</label>
                    <input type="text" id="station" name="station" value="<?php echo e(old('station', $guide->station)); ?>"
                        class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>

                <!-- Address -->
                <div>
                    <label for="address" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Address</label>
                    <textarea name="address" id="address" class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"><?php echo e(old('address', $guide->address)); ?></textarea>
                </div>

                <!-- Lat/Long -->
                <div>
                    <label for="lat_long" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Lat/Long</label>
                    <textarea name="lat_long" id="lat_long" class="mt-1 block w-full border-gray-300 rounded-lg font-semibold text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"><?php echo e(old('lat_long', $guide->lat_long)); ?></textarea>
                </div>
            </div>

              <!-- Work Area -->
            <div class="mt-4">
                <textarea name="work_area" id="work_area" class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"><?php echo e(old('work_area', $guide->work_area)); ?></textarea>
            </div>

            <hr class="mt-4">
            <h2 class="mt-4 mb-2 text-xl font-semibold text-black leading-tight">Credentials</h2>
            <div class="grid grid-cols-2 gap-6">

                <!-- Interpreter License -->
                <div>
                    <label for="interpreter_license" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">National Guide-Interpreter Licensed</label>
                    <select id="interpreter_license" name="interpreter_license" class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Please select an option</option>
                            <option value="Yes" <?php echo e(old('interpreter_license', $guide->interpreter_license) == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                            <option value="No" <?php echo e(old('interpreter_license', $guide->interpreter_license) == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </div>

                <!-- License Number -->
                <div>
                    <label for="license_number" class="block text-sm font-medium text-gray-400 dark:text-gray-100">National License Number</label>
                    <input type="text" id="license_number" name="license_number" value="<?php echo e(old('license_number', $guide->license_number)); ?>"
                        class="mt-1 block w-full border-gray-300 rounded-lg font-semibold text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>
            </div>

            <hr class="mt-3 mb-3">

            <!-- Private Vehicle -->
            <div>
                <label for="private_vehicle" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Would you like to drive guests in your own private vehicle during the tour?</label>
                <select id="private_vehicle" name="private_vehicle" class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                    <option value="">Please select an option</option>
                        <option value="Yes" <?php echo e(old('private_vehicle', $guide->private_vehicle) == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                        <option value="No" <?php echo e(old('private_vehicle', $guide->private_vehicle) == 'No' ? 'selected' : ''); ?>>No</option>
                </select>
            </div>

            <div class="grid grid-cols-2 gap-6 mt-3">
                <!-- Other License Number -->
                

                <!-- Car Type -->
                <div>
                    <label for="car_type" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Car Type</label>
                    <select id="car_type" name="car_type" class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Please select an option</option>
                            <option value="sedan" <?php echo e(old('car_type', $guide->car_type) == 'sedan' ? 'selected' : ''); ?>>Sedan</option>
                            <option value="minivan" <?php echo e(old('car_type', $guide->car_type) == 'minivan' ? 'selected' : ''); ?>>Minian</option>
                            <option value="compact_car" <?php echo e(old('car_type', $guide->car_type) == 'compact_car' ? 'selected' : ''); ?>>Compact Car</option>
                            <option value="suv" <?php echo e(old('car_type', $guide->car_type) == 'suv' ? 'selected' : ''); ?>>SUV</option>
                            <option value="other" <?php echo e(old('car_type', $guide->car_type) == 'other' ? 'selected' : ''); ?>>Other</option>
                    </select>
                </div>

                <!-- Capacity -->
                <div>
                    <label for="capacity" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Capacity</label>
                    <select id="capacity" name="capacity" class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Please select an option</option>
                            <option value="3" <?php echo e(old('capacity', $guide->capacity) == '3' ? 'selected' : ''); ?>>3</option>
                            <option value="4" <?php echo e(old('capacity', $guide->capacity) == '4' ? 'selected' : ''); ?>>4</option>
                            <option value="5" <?php echo e(old('capacity', $guide->capacity) == '5' ? 'selected' : ''); ?>>5</option>
                            <option value="6" <?php echo e(old('capacity', $guide->capacity) == '6' ? 'selected' : ''); ?>>6</option>
                            <option value="7" <?php echo e(old('capacity', $guide->capacity) == '7' ? 'selected' : ''); ?>>7</option>
                            <option value="8" <?php echo e(old('capacity', $guide->capacity) == '8' ? 'selected' : ''); ?>>8</option>
                            <option value="9" <?php echo e(old('capacity', $guide->capacity) == '9' ? 'selected' : ''); ?>>9</option>
                            <option value="10" <?php echo e(old('capacity', $guide->capacity) == '10' ? 'selected' : ''); ?>>10</option>
                            <option value="11" <?php echo e(old('capacity', $guide->capacity) == '11' ? 'selected' : ''); ?>>11</option>
                            <option value="12" <?php echo e(old('capacity', $guide->capacity) == '12' ? 'selected' : ''); ?>>12</option>
                            <option value="13" <?php echo e(old('capacity', $guide->capacity) == '13' ? 'selected' : ''); ?>>13</option>
                            <option value="14" <?php echo e(old('capacity', $guide->capacity) == '14' ? 'selected' : ''); ?>>14</option>
                            <option value="15" <?php echo e(old('capacity', $guide->capacity) == '15' ? 'selected' : ''); ?>>15</option>
                            <option value="16" <?php echo e(old('capacity', $guide->capacity) == '16' ? 'selected' : ''); ?>>16</option>
                            <option value="17" <?php echo e(old('capacity', $guide->capacity) == '17' ? 'selected' : ''); ?>>17</option>
                            <option value="18" <?php echo e(old('capacity', $guide->capacity) == '18' ? 'selected' : ''); ?>>18</option>
                            <option value="19" <?php echo e(old('capacity', $guide->capacity) == '19' ? 'selected' : ''); ?>>19</option>
                            <option value="20" <?php echo e(old('capacity', $guide->capacity) == '20' ? 'selected' : ''); ?>>20</option>
                    </select>
                </div>

                <!-- Invoice Registration -->
                <div>
                    <label for="invoice_registration" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Invoice Registration</label>
                    <select id="invoice_registration" name="invoice_registration" class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Please select an option</option>
                            <option value="Yes" <?php echo e(old('invoice_registration', $guide->invoice_registration) == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                            <option value="No" <?php echo e(old('invoice_registration', $guide->invoice_registration) == 'No' ? 'selected' : ''); ?>>No</option>
                    </select>
                </div>

                <!-- Invoice Registration Number-->
                <div>
                    <label for="invoice_registration_number" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Invoice Registration Number</label>
                    <input type="text" id="invoice_registration_number" name="invoice_registration_number" value="<?php echo e(old('invoice_registration_number', $guide->invoice_registration_number)); ?>"
                        class="mt-1 block w-full border-gray-300 rounded-lg font-semibold text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>
            </div>

            <!-- Bank Information -->
            <div class="mt-4">
                <label for="bank_information" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Bank Information</label>
                <input type="text" id="bank_information" name="bank_information" value="<?php echo e(old('bank_information', $guide->bank_information)); ?>"
                    class="mt-1 block w-full border-gray-300 rounded-lg font-semibold text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                >
            </div>

            <hr class="mt-4">
            <h2 class="mt-4 mb-2 text-xl font-semibold text-black leading-tight">Expertise</h2>
            <div class="grid grid-cols-2 gap-6">
                <!-- Number Of Tours -->
                <div>
                    <label for="number_of_tours" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Number of tours conducted</label>
                    <input type="text" id="number_of_tours" name="number_of_tours" value="<?php echo e(old('number_of_tours', $guide->number_of_tours)); ?>"
                        class="mt-1 block w-full border-gray-300 rounded-lg font-semibold text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>

                <!-- Years Of Experience -->
                <div>
                    <label for="years_of_experience" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Number of years as guide</label>
                    <input type="text" id="years_of_experience" name="years_of_experience" value="<?php echo e(old('years_of_experience', $guide->years_of_experience)); ?>"
                        class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>

                <!-- Experience Area -->
                <div>
                    <label for="experience_area" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Experience</label>
                    <textarea name="experience_area" id="experience_area" class="mt-1 block w-full border-gray-300 rounded-lg font-semibold text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"><?php echo e(old('experience_area', $guide->experience_area)); ?></textarea>
                </div>

                <!-- Availability -->
                <div>
                    <label for="availability" class="block text-sm font-medium text-gray-400 dark:text-gray-100">
                        Availability
                    </label>
                    <textarea name="availability" id="availability"
                        class="mt-1 block w-full border-gray-300 rounded-lg font-semibold text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"><?php echo e(old('availability', $guide->availability)); ?></textarea>
                </div>
            </div>

            <hr class="mt-3">
            <div class="mt-3 grid grid-cols-2 gap-6">
                <!-- English Fluency -->
                <div>
                    <label for="english_fluency" class="block text-sm font-medium text-gray-400 dark:text-gray-100">English Level (Self-determined)</label>
                    <input type="text" id="english_fluency" name="english_fluency" value="<?php echo e(old('english_fluency', $guide->english_fluency)); ?>"
                        class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>

                <!-- Other Languages -->
                <div>
                    <label for="other_languages" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Other Languages</label>
                    <select id="other_languages" name="other_languages[]" multiple class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Select Language</option>
                        <?php $__currentLoopData = $other_languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($other_language->id); ?>"
                                <?php echo e(in_array($other_language->id, json_decode($guide->other_languages, true) ?? []) ? 'selected' : ''); ?>>
                                <?php echo e($other_language->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Communication Preferred -->
                <div>
                    <label for="communication_preferred" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">Communication Preferred</label>
                    <select id="communication_preferred" name="communication_preferred[]" multiple class="select2 mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Please select an option</option>
                        <option value="email" <?php echo e(in_array('email', old('communication_preferred', $guide->communication_preferred ?? [])) ? 'selected' : ''); ?>>Email</option>
                        <option value="line" <?php echo e(in_array('line', old('communication_preferred', $guide->communication_preferred ?? [])) ? 'selected' : ''); ?>>Line</option>
                        <option value="email and line" <?php echo e(in_array('email and line', old('communication_preferred', $guide->communication_preferred ?? [])) ? 'selected' : ''); ?>>Email and Line</option>
                    </select>
                </div>

                <!-- Referred By -->
                <div>
                    <label for="referred_person" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Referred By</label>
                    <input type="text" id="referred_person" name="referred_person" value="<?php echo e(old('referred_person', $guide->referred_person)); ?>"
                        class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>
            </div>

            <hr class="mt-3">
            <div class="mt-3 grid grid-cols-2 gap-6">
                <!-- Interviewed by -->
                <div>
                    <label for="interviewed_by" class="block text-sm font-medium text-gray-400 dark:text-gray-100 mb-1">interviewed_by</label>
                    <select name="interviewed_by" id="interviewed_by" class="select2 mt-1 block w-full border border-gray-300 rounded-lg text-sm shadow-sm">
                        <option value="">Select Manager</option>
                        <?php $__currentLoopData = $managers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manager): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($manager->id); ?>" <?php echo e($guide->interviewed_by == $manager->id ? 'selected' : ''); ?>>
                                <?php echo e($manager->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Interview Date -->
                <div>
                    <label for="interview_date" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Interview date</label>
                    <input type="date" id="interview_date" name="interview_date"
                        value="<?php echo e(old('interview_date', $guide->interview_date ? \Carbon\Carbon::parse($guide->interview_date)->format('Y-m-d') : '')); ?>"
                        class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                    >
                </div>
            </div>

            <!-- Interviewer's Observations -->
            <div class="mt-3">
                <label for="interiewer_observations" class="block text-sm font-medium text-gray-400 dark:text-gray-100">interiewer's Observations</label>
                <textarea name="interiewer_observations" id="interiewer_observations" class="mt-1 block w-full border-gray-300 rounded-lg font-semibold text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"><?php echo e(old('interiewer_observations', $guide->interiewer_observations)); ?></textarea>
            </div>

            <!-- English Fluency Rating -->
            <div class="mt-3">
                <label for="english_fluency_rating" class="block text-sm font-medium text-gray-400 dark:text-gray-100">English Fluency Rating</label>
                <input type="text" id="english_fluency_rating" name="english_fluency_rating" value="<?php echo e(old('english_fluency_rating', $guide->english_fluency_rating)); ?>"
                    class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"
                >
            </div>

            <div class="mt-3">
                <label for="recording_of_interview" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Recording of interview</label>
                <div class="flex justify-between items-center mt-1 border border-gray-400 px-4 py-2 rounded-lg shadow-sm ">
                    <!-- Left Side: SVG + Description -->
                    <div class="flex items-center space-x-4">
                        <!-- SVG Icon -->
                        <svg width="30" height="23" viewBox="0 0 30 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M28.3333 14.8039C28.3333 17.9278 26.4083 20.6073 23.6667 21.7472M18.1746 7.70295C18.969 7.42549 19.8238 7.27451 20.7143 7.27451C21.5872 7.27451 22.4258 7.41957 23.2068 7.68664M8.48822 11.1452C8.13 11.0756 7.75978 11.0392 7.38096 11.0392C4.22504 11.0392 1.66667 13.5675 1.66667 16.6863C1.66667 19.2148 3.34832 21.3552 5.66667 22.0748M8.48822 11.1452C8.18275 10.3304 8.01588 9.44916 8.01588 8.52941C8.01588 4.37103 11.427 1 15.6349 1C19.5545 1 22.7828 3.92495 23.2068 7.68664M8.48822 11.1452C9.24079 11.2912 9.94038 11.5832 10.5556 11.9901M23.2068 7.68664C24.3928 8.09221 25.446 8.77915 26.2845 9.66667" stroke="#8A8C92" stroke-width="1.5" stroke-linecap="round"/>
                        </svg>

                        <!-- Description and File Input -->
                        <div>
                            <p class="text-gray-400 text-sm font-semibold">Upload File</p>
                            <p class="text-gray-500 text-xs">Upload file from local storage</p>
                        </div>
                    </div>

                    <!-- Right Side: Upload Button -->
                    <div>
                        <!-- Hidden File Input -->
                        <input type="file" id="fileInput" name="recording_of_interview"
                            class="hidden mt-2 block w-full border-gray-400 rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50">

                        <!-- Upload Button -->
                        <button id="uploadButton"
                            class="mt-2 bg-white text-black py-2 px-3 text-sm border border-gray-400 rounded-lg hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-gray-500">
                            Upload
                        </button>
                    </div>
                </div>
            </div>

            <hr class="mt-4">
            <h2 class="mt-4 mb-2 text-xl font-semibold text-black leading-tight">Guide Fee</h2>
            <label class="block text-gray-400 font-medium mb-2 text-sm">Starting Rate</label>
            <div class="relative w-full flex items-center">
                <button id="calculateBtn" class="flex items-center mt-1 px-3 pt-2 pb-3 text-black bg-gray-100 border border-r-0 border-gray-300 rounded-l-md hover:bg-gray-200 hover:text-white transition-colors duration-200">
                    <svg width="10" height="13" viewBox="0 0 10 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 -0.833252L5 6.50008M5 6.50008L9 -0.833252M5 6.50008H1M5 6.50008H9M5 6.50008V9.16675M5 12.5001V9.16675M5 9.16675H1M5 9.16675H9" stroke="#111111" stroke-width="1.5"/>
                    </svg>
                </button>

                <!-- Input Field -->
                <input type="number" id="startingRate" name="starting_rate"
                    value="<?php echo e(old('starting_rate', $guide->starting_rate)); ?>"
                    class="mt-1 block w-full border-gray-300 font-semibold rounded-r-md text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50 pl-3" />
            </div>

            <!-- Guide Fee Table -->
            <div class="mt-4">
                <label class="block text-gray-400 font-medium mb-2 text-sm">Guide Fee (Hourly Rate)</label>
                <table class="w-full border-separate border-spacing-y-2 text-sm bg-gray-100 rounded-md">
                    <thead>
                        <tr class="font-semibold">
                            <th class="text-left p-2"># of People</th>
                            <th class="text-left p-2">7 - 8+ hours</th>
                            <th class="text-left p-2">5 - 6 hours</th>
                            <th class="text-left p-2">1 - 4 hours</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="border-t border-gray-300">
                            <td class="p-2 font-semibold">1 - 6 people</td>
                            <td class="p-2"><input type="number" data-multiplier="1" name="fee[1][long]" class="fee w-full border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                            <td class="p-2"><input type="number" data-multiplier="101" name="fee[1][mid]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                            <td class="p-2"><input type="number" data-multiplier="201" name="fee[1][short]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                        </tr>
                        <tr class="border-t border-gray-200">
                            <td class="p-2 font-semibold">7 - 15 people</td>
                            <td class="p-2"><input type="number" data-multiplier="301" name="fee[1][long]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                            <td class="p-2"><input type="number" data-multiplier="401" name="fee[1][mid]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                            <td class="p-2"><input type="number" data-multiplier="501" name="fee[1][short]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                        </tr>
                        <tr class="border-t border-gray-200">
                            <td class="p-2 font-semibold">16 - 27 people</td>
                            <td class="p-2"><input type="number" data-multiplier="601" name="fee[1][long]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                            <td class="p-2"><input type="number" data-multiplier="701" name="fee[1][mid]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                            <td class="p-2"><input type="number" data-multiplier="801" name="fee[1][short]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                        </tr>
                        <tr class="border-t border-gray-200">
                            <td class="p-2 font-semibold">28+ people</td>
                            <td class="p-2"><input type="number" data-multiplier="901" name="fee[1][long]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                            <td class="p-2"><input type="number" data-multiplier="1001" name="fee[1][mid]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                            <td class="p-2"><input type="number" data-multiplier="1101" name="fee[1][short]" class="fee w-full border border-gray-300 rounded-md px-2 py-2 focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50" /></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- Hidden Field for Guide Fee -->
            <input type="hidden" name="guide_fee" id="feesInput" value="<?php echo e(old('guide_fee', json_encode($guide->guide_fee))); ?>">

            <!-- Comment -->
            <div class="mt-3">
                <label for="comment" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Comment</label>
                <textarea name="comment" id="comment" class="mt-1 block w-full border-gray-300 font-semibold rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50"><?php echo e(old('comment', $guide->comment)); ?></textarea>
            </div>

            <!-- Important Notes -->
            <div class="mt-3">
                <label class="block text-sm text-gray-400 font-medium mb-2">Important Notes</label>
                <div id="importantNotes" class="flex gap-6">
                    <!-- Pros Section -->
                    <div class="bg-gray-100 p-2 w-1/3 rounded-lg">
                        <label class="block text-sm text-black font-medium mb-1">Pros</label>
                        <button type="button" onclick="addNote('pros')" class="border border-gray-400 bg-white rounded-lg px-12 py-1 text-sm text-gray-500 w-full text-center hover:bg-gray-500 transition-colors duration-200">+ Add new</button>
                    </div>

                    <!-- Cons Section -->
                    <div class="bg-gray-100 p-2 w-1/3 rounded-lg">
                        <label class="block text-sm text-black font-medium mb-1">Cons</label>
                        <button type="button" onclick="addNote('cons')" class="border border-gray-400 bg-white rounded-lg px-12 py-1 text-sm text-gray-500 w-full text-center hover:bg-gray-500 transition-colors duration-200">+ Add new</button>
                    </div>

                    <!-- Other Section -->
                    <div class="bg-gray-100 p-2 w-1/3 rounded-lg">
                        <label class="block text-sm text-black font-medium mb-1">Other</label>
                        <button type="button" onclick="addNote('other')" class="border border-gray-400 bg-white rounded-lg px-12 py-1 text-sm text-gray-500 w-full text-center hover:bg-gray-500 transition-colors duration-200">+ Add new</button>
                    </div>
                </div>
            </div>


            <!-- Dynamic Notes Container -->
            <div id="notesContainer" class="mt-3"></div>
                <!-- Hidden Input for Saving Notes -->
                <input type="hidden" name="important_notes" id="importantNotesInput"
                    value="<?php echo e(old('important_notes', json_encode($guide->important_notes ?? []))); ?>">
            </div>
            


            <div class="mt-3 grid grid-cols-2 gap-6">

                <!-- Line Group ID -->
                <div>
                    <label class="block text-sm text-gray-400">Line Group ID</label>
                    <input type="text" class="mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm  focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50">
                    <span class="text-gray-500 text-xs">Create Line group for tour guide and Tour guide type: <?php echo e($guide->line_group_id ? $guide->line_group_id : 'N/A'); ?></span>
                </div>

                <!-- Line User ID -->
                <div>
                    <label class="block text-sm text-gray-400">Line User ID</label>
                    <input type="text" name="line_user_id" class="mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm  focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50">
                </div>

                <!-- Contract -->
                <div>
                    

                        <label for="contract" class="block text-sm font-medium text-gray-400 dark:text-gray-100">Contract</label>
                        <div class="flex justify-between items-center mt-1 border border-gray-400 px-4 py-2 rounded-lg shadow-sm ">
                            <!-- Left Side: SVG + Description -->
                            <div class="flex items-center space-x-4">
                                <!-- SVG Icon -->
                                <svg width="30" height="23" viewBox="0 0 30 23" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M28.3333 14.8039C28.3333 17.9278 26.4083 20.6073 23.6667 21.7472M18.1746 7.70295C18.969 7.42549 19.8238 7.27451 20.7143 7.27451C21.5872 7.27451 22.4258 7.41957 23.2068 7.68664M8.48822 11.1452C8.13 11.0756 7.75978 11.0392 7.38096 11.0392C4.22504 11.0392 1.66667 13.5675 1.66667 16.6863C1.66667 19.2148 3.34832 21.3552 5.66667 22.0748M8.48822 11.1452C8.18275 10.3304 8.01588 9.44916 8.01588 8.52941C8.01588 4.37103 11.427 1 15.6349 1C19.5545 1 22.7828 3.92495 23.2068 7.68664M8.48822 11.1452C9.24079 11.2912 9.94038 11.5832 10.5556 11.9901M23.2068 7.68664C24.3928 8.09221 25.446 8.77915 26.2845 9.66667" stroke="#8A8C92" stroke-width="1.5" stroke-linecap="round"/>
                                </svg>

                                <!-- Description and File Input -->
                                <div>
                                    <p class="text-gray-400 text-sm font-semibold">Upload File</p>
                                    <p class="text-gray-500 text-xs">Upload file from local storage</p>
                                </div>
                            </div>

                            <!-- Right Side: Upload Button -->
                            <div>
                                <!-- Hidden File Input -->
                                <input type="file" id="contractfileInput" name="contract" accept=".pdf,.doc,.docx"
                                    class="hidden mt-2 block w-full border-gray-400 rounded-lg text-sm shadow-sm focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50">

                                <!-- Upload Button -->
                                <button id="contractUploadButton"
                                    class="mt-2 bg-white text-black py-2 px-3 text-sm border border-gray-400 rounded-lg hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-gray-500">
                                    Upload
                                </button>
                            </div>
                        </div>
                </div>


                <!-- Sign Date -->
                <div>
                    <label class="text-sm block text-gray-400">Date</label>
                    <input type="datetime-local" name="sign_date"
                    value="<?php echo e(old('sign_date', $guide->sign_date ? \Carbon\Carbon::parse($guide->sign_date)->format('Y-m-d\TH:i') : '')); ?>"
                    class="mt-1 block w-full border-gray-300 rounded-lg text-sm shadow-sm  focus:border-gray-500 focus:ring focus:ring-gray-500 focus:ring-opacity-50">
                </div>

            </div>

            

            <!-- Buttons -->
            <div class="flex items-center justify-between mt-6">
                <a href="<?php echo e(route('admin.tour-guides.index')); ?>" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                    Back to Tour Guide List
                </a>
                <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent text-sm rounded-lg font-semibold text-white tracking-widest shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500" style="background-color: #2E8B57;">
                    Save
                </button>
            </div>

        </form>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>

<style>
    .select2-container--default .select2-selection--single {
        border: 1px solid #d1d5db;
        border-radius: 0.375rem;
        height: 38px;
        padding: 6px 12px;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
        color: #374151;
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 36px;
    }
</style>
<script>
    $(document).ready(function() {
        $('.select2').select2({ width: '100%' });

        var input = document.querySelector("#phone");

        // Initialize intl-tel-input
        var iti = window.intlTelInput(input, {
            initialCountry: "auto",  // Detect user's country automatically
            geoIpLookup: function(callback) {
                fetch('http://www.geoplugin.net/json.gp')
                    .then(response => response.json())
                    .then(data => callback(data.geoplugin_countryCode))
                    .catch(() => callback("US"));
            },

            separateDialCode: true,
            preferredCountries: ["us", "gb", "jp", "in", "de"],
            utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/utils.js"
        });

        $("form").submit(function () {
            var fullNumber = iti.getNumber();
            $("#phone").val(fullNumber);
        });

        var selectedPrefectureId = "<?php echo e($guide->prefecture_id); ?>";
        var selectedCityId = "<?php echo e($guide->city_id); ?>";

        $('#region_id').change(function() {
            var regionId = $(this).val();
            // console.log("Region Changed, Fetching Prefectures for Region ID:", regionId);
            $('#prefecture_id').html('<option value="">Select Prefecture</option>');
            $('#city_id').html('<option value="">Select City</option>');

            if (regionId) {
                $.ajax({
                    url: "<?php echo e(route('get.prefectures')); ?>?region_id=" + regionId,
                    type: "GET",
                    success: function(data) {
                        $.each(data, function(key, value) {
                            var selected = value.id == selectedPrefectureId ? 'selected' : '';
                            $('#prefecture_id').append('<option value="' + value.id + '" ' + selected + '>' + value.eng_name + '</option>');
                        });
                        $('#prefecture_id').trigger('change');
                    }
                });
            }
        });

        $('#prefecture_id').change(function() {
            var prefectureId = $(this).val();
            $('#city_id').html('<option value="">Select City</option>');

            if (prefectureId) {
                $.ajax({
                    url: "<?php echo e(route('get.cities')); ?>?prefecture_id=" + prefectureId,
                    type: "GET",
                    success: function(data) {
                        console.log("Cities API Response:", data);
                        $.each(data, function(key, value) {
                            var selected = value.id == selectedCityId ? 'selected' : '';
                            $('#city_id').append('<option value="' + value.id + '" ' + selected + '>' + value.eng_name + '</option>');
                        });
                        $('#city_id').val(selectedCityId).trigger('change');
                        // console.log($('#city_id').val());

                    }
                });
            }
        });

        $('#region_id').trigger('change');
    });

    document.getElementById('uploadButton').addEventListener('click', function() {
        event.preventDefault();
        document.getElementById('fileInput').click();
    });

    document.getElementById('contractUploadButton').addEventListener('click', function() {
        event.preventDefault();
        document.getElementById('contractfileInput').click();
    });


    // Start Guide Fee
    document.addEventListener("DOMContentLoaded", function () {
        let feesInput = document.getElementById("feesInput").value;

        if (feesInput) {
            let feesData = JSON.parse(feesInput);
            let feeElements = document.querySelectorAll(".fee");

            feeElements.forEach(input => {
                let multiplier = input.getAttribute("data-multiplier");
                if (feesData && feesData.hasOwnProperty(multiplier)) {
                    input.value = feesData[multiplier];
                }
            });
        }
    });

    document.getElementById("calculateBtn").addEventListener("click", function (event) {
        event.preventDefault();
        let startingRate = parseFloat(document.getElementById("startingRate").value) || 0;
        let feeElements = document.querySelectorAll(".fee");

        feeElements.forEach(input => {
            let multiplier = parseFloat(input.getAttribute("data-multiplier")) || 1;
            input.value = (startingRate * multiplier).toFixed(2);
        });

        saveFeesToForm();
    });

    function saveFeesToForm() {
        let feeElements = document.querySelectorAll(".fee");
        let feesData = {};

        feeElements.forEach(input => {
            let multiplier = input.getAttribute("data-multiplier");
            feesData[multiplier] = input.value;
        });

        document.getElementById("feesInput").value = JSON.stringify(feesData);
    }
    // End Guide Fee


    //Start Important Notes
    document.addEventListener("DOMContentLoaded", function () {
        let importantNotesInput = document.getElementById("importantNotesInput").value;

        if (importantNotesInput) {
            try {
                let notesData = JSON.parse(importantNotesInput);
                notesData.forEach(note => {
                    addNote(note.type, note.note);
                });
            } catch (e) {
                console.error("Invalid JSON in important_notes:", e);
            }
        }
    });

    function addNote(type, value = "") {
        const container = document.getElementById("notesContainer");
        const div = document.createElement("div");
        div.classList.add("flex", "items-center", "gap-2", "mt-2");
        const textarea = document.createElement("textarea");
        textarea.classList.add("p-2", "border", "rounded", "w-full");
        textarea.placeholder = `Enter ${type}`;
        textarea.dataset.type = type;
        textarea.value = value;

        // Delete button
        const deleteBtn = document.createElement("button");
        deleteBtn.innerHTML = "❌";
        deleteBtn.classList.add("text-red-500", "p-1", "rounded", "hover:bg-gray-200");
        deleteBtn.type = "button";
        deleteBtn.onclick = () => {
            div.remove();
            updateImportantNotes();
        };
        div.appendChild(textarea);
        div.appendChild(deleteBtn);
        container.appendChild(div);
        textarea.addEventListener("input", updateImportantNotes);
    }

    function updateImportantNotes() {
        const notes = [];
        document.querySelectorAll("#notesContainer textarea").forEach(textarea => {
            if (textarea.value.trim() !== "") {
                notes.push({
                    type: textarea.dataset.type,
                    note: textarea.value.trim()
                });
            }
        });

        // Save notes as JSON string in hidden input
        document.getElementById("importantNotesInput").value = JSON.stringify(notes);
    }

    document.querySelector("form").addEventListener("submit", updateImportantNotes);
    // End Important Notes

    // Start Status
    function toggleStatus() {
        let statusInput = document.getElementById("statusInput");
        let status = statusInput.value === "1" ? "0" : "1";
        statusInput.value = status;

        updateToggleUI(status);
    }
    function updateToggleUI(status) {
        let toggleButton = document.getElementById("toggleButton");
        let toggleCircle = document.getElementById("toggleCircle");
        let statusText = document.getElementById("statusText");

        if (status === "1") {
            toggleButton.classList.add("bg-green-500");
            toggleButton.classList.remove("bg-gray-300");
            toggleCircle.classList.add("translate-x-6");
            statusText.textContent = "Active";
        } else {
            toggleButton.classList.add("bg-gray-300");
            toggleButton.classList.remove("bg-green-500");
            toggleCircle.classList.remove("translate-x-6");
            statusText.textContent = "Inactive";
        }
    }

    function showHideStatusField() {
        let statusInput = document.getElementById("statusInput");
        let statusContainer = document.getElementById("statusContainer");

        if (statusInput.value === "0" || statusInput.value === "1") {
            statusContainer.style.display = "block";
            updateToggleUI(statusInput.value);
        } else {
            statusContainer.style.display = "none";
        }
    }

    window.onload = showHideStatusField;
    // End Status
</script>
<?php /**PATH C:\xampp8.2\htdocs\Portal\resources\views/admin/tour_guide/edit.blade.php ENDPATH**/ ?>