<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['name'];
    protected $dates = ['deleted_at'];

    public function responseTemplates()
    {
        return $this->belongsToMany(ResponseTemplate::class, 'group_response_template');
    }

    public function tours()
    {
        return $this->belongsToMany(Tour::class, 'group_tour');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($group) {
            $group->responseTemplates()->delete();
        });
    }
}

