<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ResponseTemplate extends Model
{
    use SoftDeletes;

    protected $fillable = ['title', 'write_to', 'reason', 'stage_of_booking', 'type', 'subject', 'content', 'notes'];

    protected $dates = ['deleted_at'];

    public function groups()
    {
        return $this->belongsToMany(Group::class, 'group_response_template');
    }
}
