<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tour extends Model
{
    use SoftDeletes;

    protected $fillable = ['name', 'status', 'uid', 'bokun_id', 'bokun_title', 'time', 'start_time', 'end_time', 'duration', 'region_id', 'prefecture_id', 'city_id', 'operation_area', 'operation_lat_lng', 'guide_free', 'link_form', 'tour_instructions', 'meet_point', 'meet_lat_lng'];
    protected $dates = ['deleted_at'];

    public function groups()
    {
        return $this->belongsToMany(Group::class, 'group_tour');
    }

    public function managers()
    {
        return $this->belongsToMany(User::class, 'tour_managers');
    }

    public function tourTypes()
    {
        return $this->hasMany(TourType::class, 'tour_id');
    }

    public function region()
    {
        return $this->belongsTo(Region::class, 'region_id');
    }

    public function prefecture()
    {
        return $this->belongsTo(Prefecture::class, 'prefecture_id');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id');
    }
}
