<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            $table->integer('uid');
            $table->integer('bokun_id');
            $table->text('bokun_title');
            $table->string('time')->nullable();
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->integer('duration')->nullable();
            $table->unsignedBigInteger('region_id')->nullable();
            $table->unsignedBigInteger('prefecture_id')->nullable();
            $table->unsignedBigInteger('city_id')->nullable();
            $table->text('operation_area')->nullable();
            $table->text('operation_lat_lng')->nullable();
            $table->string('guide_free')->nullable();
            $table->text('link_form')->nullable();
            $table->text('tour_instructions')->nullable();
            $table->text('meet_point')->nullable();
            $table->text('meet_lat_lng')->nullable();

            $table->foreign('region_id')->references('id')->on('regions')->onDelete('cascade');
            $table->foreign('prefecture_id')->references('id')->on('prefectures')->onDelete('cascade');
            $table->foreign('city_id')->references('id')->on('cities')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            $table->dropColumn(['uid', 'bokun_id', 'bokun_title', 'time', 'start_time', 'end_time', 'duration', 'region_id', 'prefecture_id', 'city_id', 'operation_area', 'operation_lat/lng', 'guide_free', 'manager', 'link_form', 'tour_instructions', 'meet_point', 'meet_lat/lng']);
        });
    }
};
