<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Group Details</h1>
    </x-slot>

    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md">
        <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Group Name</label>
            <p class="mt-1 text-gray-900 dark:text-gray-100">{{ $group->name }}</p>
        </div>

        <div class="flex items-center justify-between mt-6">
            <a href="{{ route('admin.groups.index') }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                Back to groups List
            </a>
            <div class="flex items-center justify-end space-x-4">
            <a href="{{ route('admin.groups.edit', $group) }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-white text-xs uppercase tracking-widest shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Edit Group
            </a>
            <form action="{{ route('admin.groups.destroy', $group) }}" method="POST" class="inline ml-4">
                @csrf
                @method('DELETE')
                <button type="submit" class="bg-red-500 text-white px-4 py-2 rounded-md">Delete Group</button>
            </form>
        </div>
        </div>
    </div>
</x-admin-layout>
