<x-admin-layout>
    @include('admin.response_templates.format_popup')
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Edit Response Template</h1>
    </x-slot>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <form action="{{ route('admin.response_templates.update', $responseTemplate) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Title</label>
                <input type="text" name="title" value="{{ old('title', $responseTemplate->title) }}" class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm" required>
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Write To</label>
                <select name="write_to" class="block w-full border border-gray-300 rounded-md shadow-sm" required>
                    <option value="Customer" {{ old('write_to', $responseTemplate->write_to) == 'Customer' ? 'selected' : '' }}>Customer</option>
                    <option value="Tour staff" {{ old('write_to', $responseTemplate->write_to) == 'Tour staff' ? 'selected' : '' }}>Tour staff</option>
                </select>
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Reason</label>
                <input type="text" name="reason" value="{{ old('reason', $responseTemplate->reason) }}" class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm" required>
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Stage of Booking</label>
                <select name="stage_of_booking" class="block w-full border border-gray-300 rounded-md shadow-sm" required>
                    <option value="beginning" {{ old('stage_of_booking', $responseTemplate->stage_of_booking) == 'beginning' ? 'selected' : '' }}>Beginning</option>
                    <option value="middle" {{ old('stage_of_booking', $responseTemplate->stage_of_booking) == 'middle' ? 'selected' : '' }}>Middle</option>
                    <option value="end" {{ old('stage_of_booking', $responseTemplate->stage_of_booking) == 'end' ? 'selected' : '' }}>End</option>
                </select>
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Type</label>
                <input type="text" name="type" value="{{ old('type', $responseTemplate->type) }}" class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm" required>
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Subject</label>
                <input type="text" name="subject" value="{{ old('subject', $responseTemplate->subject) }}" class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm" required>
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Content</label>
                <textarea name="content" id="content" class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm">{{ old('content', $responseTemplate->content) }}</textarea>
                <button type="button" onclick="openPopup()" class="px-4 py-2 mt-2 text-white bg-indigo-600 rounded hover:bg-indigo-700">Format</button>
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Notes</label>
                <textarea name="notes" class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm">{{ old('notes', $responseTemplate->notes) }}</textarea>
            </div>

            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300">Groups</label>
                <select name="groups[]" id="groups" multiple class="block w-full border border-gray-300 rounded-md shadow-sm" required>
                    @foreach($groups as $group)
                        <option value="{{ $group->id }}" {{ in_array($group->id, old('groups', $responseTemplate->groups->pluck('id')->toArray() ?? [])) ? 'selected' : '' }}>
                            {{ $group->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="flex items-center justify-between">
                <a href="{{ route('admin.response_templates.index') }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">Back to Groups List</a>
                <button type="submit" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    Update Response Template
                </button>
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {
            $('#groups').select2({
                placeholder: "Select Groups",
                allowClear: true,
                width: '100%'
            });
        });
    </script>
</x-admin-layout>
