<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Response Template Details</h1>
    </x-slot>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-gray-100">Template Information</h2>

        <p class="mt-2 text-gray-600 dark:text-gray-400">Title:  <span class="font-medium">{{ $responseTemplate->title }}</span></p>
        <p class="mt-2 text-gray-600 dark:text-gray-400">Write To: <span class="font-medium">{{ $responseTemplate->write_to }}</span></p>
        <p class="mt-2 text-gray-600 dark:text-gray-400">Reason:  <span class="font-medium">{{ $responseTemplate->reason }}</span></p>
        <p class="mt-2 text-gray-600 dark:text-gray-400">Stage of Booking:  <span class="font-medium">{{ $responseTemplate->stage_of_booking }}</span></p>
        <p class="mt-2 text-gray-600 dark:text-gray-400">Type:  <span class="font-medium">{{ $responseTemplate->type }}</span></p>
        <p class="mt-2 text-gray-600 dark:text-gray-400">Subject:  <span class="font-medium">{{ $responseTemplate->subject }}</span></p>
        <p class="mt-2 text-gray-600 dark:text-gray-400">Content: </p>
        <div class="p-4 mt-2 text-gray-700 bg-gray-100 rounded-lg dark:text-gray-300 dark:bg-gray-700">
            {!! nl2br(e($responseTemplate->content)) !!}
        </div>
        <p class="mt-2 text-gray-600 dark:text-gray-400">Notes: <span class="font-medium">{{ $responseTemplate->notes }}</span></p>
        <p class="mt-2 text-gray-600 dark:text-gray-400">Groups: <span class="font-medium">{{ $responseTemplate->groups->pluck('name')->implode(', ') }}</span></p>

        <div class="flex items-center justify-between mt-4">
            <a href="{{ route('admin.response_templates.index') }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                Back to List
            </a>
            <a href="{{ route('admin.response_templates.edit', $responseTemplate) }}" class="px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700">
                Edit Template
            </a>
        </div>
    </div>
</x-admin-layout>
