<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Edit Role</h1>
    </x-slot>

    <div class="flex justify-center">
        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg w-full max-w-3xl">
            <form action="{{ route('admin.roles.update', $role) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- Role Name -->
                <div class="mb-4">
                    <label for="name" class="block text-sm font-medium text-gray-700">Role Name</label>
                    <input type="text" name="name" id="name" value="{{ old('name', $role->name) }}"
                        class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm
                        focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm" required>
                    @error('name')
                        <p class="text-red-500 text-sm mt-2">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Permissions Section -->
                <h3 class="text-lg font-semibold mb-2">Permissions</h3>

                <div class="grid grid-cols-2 gap-4">
                    @foreach ($modules as $module => $permissions)
                        @php
                            $allChecked = $permissions->every(fn($perm) => $role->hasPermissionTo($perm));
                        @endphp
                        <div class="bg-gray-100 dark:bg-gray-700 p-4 rounded-lg shadow-md">

                            <!-- Module Checkbox -->
                            <div class="flex items-center mb-3">
                                <input type="checkbox" id="module-{{ $module }}" class="module-checkbox"
                                    {{ $allChecked ? 'checked' : '' }}
                                    onclick="toggleModule('{{ $module }}')">
                                <label for="module-{{ $module }}" class="font-bold ml-2 text-lg">{{ ucfirst($module) }}</label>
                            </div>

                            <!-- Permissions List -->
                            <div class="space-y-1">
                                @foreach ($permissions as $permission)
                                    <div class="flex items-center p-1">
                                        <input type="checkbox" name="permissions[]" value="{{ $permission->id }}"
                                            class="{{ $module }}-permission"
                                            {{ $role->hasPermissionTo($permission) ? 'checked' : '' }}
                                            onclick="checkModule('{{ $module }}')">
                                        <label class="ml-2 text-sm">{{ $permission->name }}</label>
                                    </div>
                                @endforeach
                            </div>

                        </div>
                    @endforeach
                </div>

                <div class="flex items-center justify-end mt-6">
                    <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-md">Update Role</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function toggleModule(module) {
            let moduleCheckbox = document.getElementById('module-' + module);
            let permissionCheckboxes = document.querySelectorAll('.' + module + '-permission');

            permissionCheckboxes.forEach(checkbox => {
                checkbox.checked = moduleCheckbox.checked;
            });
        }

        function checkModule(module) {
            let moduleCheckbox = document.getElementById('module-' + module);
            let permissionCheckboxes = document.querySelectorAll('.' + module + '-permission');
            let allChecked = Array.from(permissionCheckboxes).every(cb => cb.checked);

            moduleCheckbox.checked = allChecked;
        }
    </script>
</x-admin-layout>
