<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Roles</h1>
    </x-slot>
    <x-message type="success" message="success" />
    <x-message type="danger" message="error" />
    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <!-- Desktop View -->
        <div class="hidden md:block">
            <a href="{{ route('admin.roles.create') }}" class="inline-flex items-center px-4 py-2 mb-4 text-xs font-semibold tracking-widest text-white uppercase bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Add New Role
            </a>

            <table class="min-w-full divide-y divide-gray-200">
                <thead>
                    <tr>
                        <th class="px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase">Role Name</th>
                        <th class="px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase">Permissions</th>
                        <th class="px-6 py-3 text-xs font-medium tracking-wider text-right text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($roles as $role)
                        <tr>
                            <td class="px-6 py-4 text-sm font-medium text-gray-900 whitespace-nowrap">{{ $role->name }}</td>
                            <td class="px-6 py-4 text-sm text-gray-500 whitespace-nowrap overflow-x-auto max-w-xs">
                                <div class="flex flex-wrap gap-1">
                                    @foreach($role->permissions as $permission)
                                        <span class="px-2 py-1 text-xs text-gray-800 bg-gray-200 rounded-full">{{ $permission->name }}</span>
                                    @endforeach
                                </div>
                            </td>
                            <td class="px-6 py-4 text-sm font-medium text-right whitespace-nowrap">
                                <a href="{{ route('admin.roles.show', $role) }}" class="text-indigo-600 hover:text-green-900">View</a>
                                <a href="{{ route('admin.roles.edit', $role) }}" class="ml-4 text-indigo-600 hover:text-indigo-900">Edit</a>
                                <button type="button" class="inline ml-4 text-red-600 dark:text-red-400 hover:text-red-900 dark:hover:text-red-300" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $role->id }}">
                                    Delete
                                </button>
                                <!-- Delete Modal Component -->
                                <x-delete-modal :type="'Role'" :action="'deletion'" :id="$role->id" :name="$role->name" route="admin.roles.destroy" />
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Mobile View -->
        <div class="block space-y-4 md:hidden">
            <a href="{{ route('admin.roles.create') }}" class="inline-block px-4 py-2 mb-4 text-white bg-blue-500 rounded">Create Role</a>

            @foreach($roles as $role)
                <div class="p-4 bg-white rounded-lg shadow-md dark:bg-gray-800">
                    <div class="flex items-center justify-between mb-2">
                        <div class="text-lg font-semibold text-gray-900 dark:text-gray-100">{{ $role->name }}</div>
                    </div>
                    <div class="block md:hidden">
                        <div class="mb-2">
                            @foreach($role->permissions as $permission)
                                <span class="block px-2 py-1 mb-1 text-xs text-gray-800 bg-gray-200 rounded-full">{{ $permission->name }}</span>
                            @endforeach
                        </div>
                    </div>
                    <div class="flex space-x-4">
                        <a href="{{ route('admin.roles.show', $role) }}" class="text-green-600 hover:text-green-900">Show</a>
                        <a href="{{ route('admin.roles.edit', $role) }}" class="ml-4 text-indigo-600 hover:text-indigo-900">Edit</a>
                        <form action="{{ route('admin.roles.destroy', $role) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this role?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                        </form>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</x-admin-layout>
