<div x-data="{ open: false }">
    <!-- Button to Open Modal -->
    <button @click="open = true"
        class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
        Import Tour From Bokun
    </button>

    <!-- Modal (Hidden by Default) -->
    <div x-show="open" class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50">
        <div class="bg-white rounded-lg p-6 shadow-lg w-96">
            <h2 class="text-lg font-bold mb-4">Enter Bokun ID</h2>

            <!-- Bokun ID Input -->
            <form action="{{ route('admin.tour_settings.importTour') }}" method="POST">
                @csrf
                <div>
                    <label for="bokun_id" class="block text-sm font-medium text-gray-700">Bokun ID</label>
                    <input type="text" id="bokun_id" name="bokun_id" required
                        class="mt-1 block w-full px-4 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">
                </div>

                <!-- Buttons -->
                <div class="flex justify-end mt-4">
                    <button type="button" @click="open = false"
                        class="mr-2 px-4 py-2 bg-gray-300 rounded-md">Cancel</button>
                    <button type="submit"
                        class="ml-4 px-4 py-2 bg-indigo-600 text-white rounded-md">Import</button>
                </div>
            </form>
        </div>
    </div>
</div>
