<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Edit User</h1>
    </x-slot>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <form action="{{ route('admin.users.update', $user) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <!-- Grid Layout with 6 Columns -->
            <div class="grid grid-cols-1 gap-6 mt-4 sm:grid-cols-2">
                <!-- First Name Field -->
                <div>
                    <label for="first_name" class="block text-sm font-medium text-gray-700 dark:text-gray-200">First Name</label>
                        <input  type="text" value="{{ old('first_name', $user->first_name) }}" name="first_name" id="first_name" required
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Last Name Field -->
                <div>
                    <label for="last_name" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Last Name</label>
                        <input type="text" value="{{ old('last_name', $user->last_name) }}" name="last_name" id="last_name" required
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Japanese Name Field -->
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Japanese Name</label>
                        <input type="text" name="name" value="{{ old('name', $user->name) }}" id="name" required
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Line Name Field -->
                <div>
                    <label for="line_name" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Line Name</label>
                        <input type="text" name="line_name" value="{{ old('line_name', $user->line_name) }}" id="line_name"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Login Email Field -->
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Login Email</label>

                        <input type="email" name="email" value="{{ old('email', $user->email) }}" id="email" required
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Operating Location Field -->
                <div>
                    <label for="operating_location" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Operating Location</label>
                        <input type="text" name="operating_location" value="{{ old('operating_location', $user->operating_location) }}" id="operating_location"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Personal Email Field -->
                <div>
                    <label for="personal_email" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Personal Email (Optional)</label>
                        <input type="email" name="personal_email" value="{{ old('personal_email', $user->personal_email) }}" id="personal_email"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Gender Field -->
                <div>
                    <label for="gender" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Gender</label>
                    <div class="relative mt-2">
                        <select id="gender" name="gender"
                            class="w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 outline-gray-300 focus:outline-2 focus:outline-indigo-600 sm:text-sm">
                            <option value="male" {{ old('gender', $user->gender) == 'male' ? 'selected' : '' }}>Male</option>
                            <option value="female" {{ old('gender', $user->gender) == 'female' ? 'selected' : '' }}>Female</option>
                        </select>
                    </div>
                </div>

                <!-- Age Field -->
                <div>
                    <label for="age" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Age</label>
                        <input type="number" min="1" max="100" name="age" id="age" value="{{ old('age', $user->age) }}"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Birth Date -->
                <div>
                    <label for="birth_date" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Birth Date </label>
                    <input type="date" name="birth_date" id="birth_date" value="{{ old('birth_date', $user->birth_date) }}"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Residence Field -->
                <div>
                    <label for="residence" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Residence</label>
                        <input type="text" name="residence" id="residence" value="{{ old('residence', $user->residence) }}"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Line Group Chat Field -->
                <div>
                    <label for="line_group_chat" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Line group chat </label>
                    <input type="text" name="line_group_chat" id="line_group_chat" value="{{ old('line_group_chat', $user->line_group_chat) }}"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- Role Field -->
                <div>
                    <label for="role" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Roles</label>
                    <div class="relative mt-2">
                        <select id="role" name="role_id"
                            class="w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 outline-gray-300 focus:outline-2 focus:outline-indigo-600 sm:text-sm">
                            @foreach ($roles as $role)
                                <option value="{{ $role->id }}" {{ $user->hasRole($role->id) ? 'selected' : '' }}>
                                    {{ $role->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <!-- Address Field -->
                <div>
                    <label for="address" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Address</label>
                        <textarea name="address" id="address"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">{{ old('address', $user->address) }}</textarea>
                </div>

                <!-- Other Address Field -->
                <div>
                    <label for="other_address" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Other Address</label>
                        <textarea name="other_address" id="other_address"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">{{ old('other_address', $user->other_address) }}</textarea>
                </div>

                <!-- Details Field -->
                <div>
                    <label for="detail" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Detail (Optional)</label>
                        <textarea name="detail" id="detail"
                            class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">{{ old('detail', $user->detail) }}</textarea>
                </div>

                <!-- Bank info Field -->
                <div>
                    <label for="bank_info" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Bank info </label>
                    <textarea name="bank_info" id="bank_info"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">{{ old('bank_info', $user->bank_info) }}</textarea>
                </div>

                <!-- Working Hours Field -->
                <div>
                    <label for="working_hours" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Working Hours </label>
                    <textarea name="working_hours" id="working_hours"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">{{ old('working_hours', $user->working_hours) }}</textarea>
                </div>


                <!-- Working Hours Other Field -->
                <div>
                    <label for="working_hours_other" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Working Hours Other</label>
                    <textarea name="working_hours_other" id="working_hours_other"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">{{ old('working_hours_other', $user->working_hours_other) }}</textarea>
                </div>

                <!-- other Field -->
                <div>
                    <label for="other" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Other </label>
                    <textarea name="other" id="other"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">{{ old('other', $user->other) }}</textarea>
                </div>

                <!-- Started On Date -->
                <div>
                    <label for="started_on" class="block text-sm font-medium text-gray-700 dark:text-gray-200">Started On </label>
                    <input type="date" name="started_on" id="started_on" value="{{ old('started_on', $user->started_on) }}"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                </div>

                <!-- User Image Field -->
                <div>
                    <div class="col-span-full">
                        <label class="block text-sm font-medium text-gray-900">User Photo</label>
                        <div class="flex flex-col items-center p-6 mt-2 border-2 border-gray-400 border-dashed rounded-lg">
                            @if ($user->user_image)
                            <img id="imagePreview" class="w-24 h-24 rounded-full {{ $user->user_image ? '' : 'hidden' }}"
                            src="{{ $user->user_image ? asset('storage/' . $user->user_image) : '' }}" />
                            @else
                                <img id="imagePreview" class="hidden w-24 h-24 rounded-full" />
                            @endif
                            <input id="user_image" name="user_image" type="file" accept="image/*" class="hidden">
                            <label for="user_image"
                            class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white transition duration-150 ease-in-out bg-gray-800 border border-transparent rounded-md dark:bg-gray-200 dark:text-gray-800 hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800">
                                Upload a file
                            </label>
                            <p class="mt-1 text-xs text-gray-600">PNG, JPG, GIF up to 10MB</p>
                        </div>
                    </div>

                </div>


                <!-- Work Email Section -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Work Email (Optional)</label>
                    <div id="work-email-container">
                        @php
                            $workEmails = json_decode($user->work_email, true) ?? [];
                        @endphp
                        @foreach ($workEmails as $index => $email)
                            <div class="flex items-center space-x-4 work-email-row">
                                <input type="email" name="work_email[]" value="{{ old('work_email.' . $index, $email) }}"
                                    class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                                <button type="button" class="px-2 py-1 text-white bg-red-500 rounded-md remove-work-email">−</button>
                            </div>
                        @endforeach
                        <!-- Default empty field -->
                        <div class="flex items-center space-x-4 work-email-row">
                            <input type="email" name="work_email[]" class="block w-full mt-1 border-gray-300 rounded-md shadow-sm">
                            <button type="button" class="px-2 py-1 text-white bg-green-500 rounded-md add-work-email">+</button>
                        </div>
                    </div>
                </div>

                <!-- Share Email Section -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Share Email (Optional)</label>
                    <div id="share-email-container">
                        @php
                            $shareEmails = json_decode($user->share_email, true) ?? [];
                        @endphp
                        @foreach ($shareEmails as $index => $email)
                            <div class="flex items-center space-x-4 share-email-row">
                                <input type="email" name="share_email[]" value="{{ old('share_email.' . $index, $email) }}"
                                    class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring focus:ring-indigo-500 focus:ring-opacity-50">
                                <button type="button" class="px-2 py-1 text-white bg-red-500 rounded-md remove-share-email">−</button>
                            </div>
                        @endforeach
                        <!-- Default empty field -->
                        <div class="flex items-center space-x-4 share-email-row">
                            <input type="email" name="share_email[]" class="block w-full mt-1 border-gray-300 rounded-md shadow-sm">
                            <button type="button" class="px-2 py-1 text-white bg-green-500 rounded-md add-share-email">+</button>
                        </div>
                    </div>
                </div>

                <!-- Phone Number Section -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Phone Number</label>
                    <div id="phone-number-container">
                        @php
                            $phoneNumbers = json_decode($user->phone_number, true) ?? [];
                            $phoneTypes = json_decode($user->phone_number_type, true) ?? [];
                        @endphp

                        @foreach ($phoneNumbers as $index => $phone)
                            <div class="flex items-center space-x-4 phone-number-row">
                                <input type="text" name="phone_number[]" value="{{ old('phone_number.' . $index, $phone) }}"
                                    class="w-full mt-1 border-gray-300 rounded-md shadow-sm">
                                <select name="phone_number_type[]" class="mt-1 border-gray-300 rounded-md shadow-sm">
                                    @foreach (['Personal', 'JA Mobile', 'JA Booking Phone', 'JA Global', 'Office Phone Number', 'Bookings Phone Number'] as $type)
                                        <option value="{{ $type }}" {{ old('phone_number_type.' . $index, $phoneTypes[$index] ?? '') == $type ? 'selected' : '' }}>{{ $type }}</option>
                                    @endforeach
                                </select>
                                <button type="button" class="px-2 py-1 text-white bg-red-500 rounded-md remove-phone">−</button>
                            </div>
                        @endforeach

                        <!-- Default empty field -->
                        <div class="flex items-center space-x-4 phone-number-row">
                            <input type="text" name="phone_number[]" class="w-full mt-1 border-gray-300 rounded-md shadow-sm">
                            <select name="phone_number_type[]" class="mt-1 border-gray-300 rounded-md shadow-sm">
                                <option value="Personal">Personal</option>
                                <option value="JA Mobile">JA Mobile</option>
                                <option value="JA Booking Phone">JA Booking Phone</option>
                                <option value="JA Global">JA Global</option>
                                <option value="Office Phone Number">Office Phone Number</option>
                                <option value="Bookings Phone Number">Bookings Phone Number</option>
                            </select>
                            <button type="button" class="px-2 py-1 text-white bg-green-500 rounded-md add-phone">+</button>
                        </div>
                    </div>
                </div>

                <!-- Local Number Section -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-200">Local Number</label>
                    <div id="local-number-container">
                        @php
                            $localNumbers = json_decode($user->local_number, true) ?? [];
                            $localTypes = json_decode($user->local_number_type, true) ?? [];
                        @endphp

                        @foreach ($localNumbers as $index => $number)
                            <div class="flex items-center space-x-4 local-number-row">
                                <input type="text" name="local_number[]" value="{{ old('local_number.' . $index, $number) }}"
                                    class="w-full mt-1 border-gray-300 rounded-md shadow-sm">
                                <select name="local_number_type[]" class="mt-1 border-gray-300 rounded-md shadow-sm">
                                    @foreach (['Personal', 'JA Mobile', 'JA Booking Phone', 'JA Global', 'Office Phone Number', 'Bookings Phone Number'] as $type)
                                        <option value="{{ $type }}" {{ old('local_number_type.' . $index, $localTypes[$index] ?? '') == $type ? 'selected' : '' }}>{{ $type }}</option>
                                    @endforeach
                                </select>
                                <button type="button" class="px-2 py-1 text-white bg-red-500 rounded-md remove-local">−</button>
                            </div>
                        @endforeach

                        <!-- Default empty field -->
                        <div class="flex items-center space-x-4 local-number-row">
                            <input type="text" name="local_number[]" class="w-full mt-1 border-gray-300 rounded-md shadow-sm">
                            <select name="local_number_type[]" class="mt-1 border-gray-300 rounded-md shadow-sm">
                                <option value="Personal">Personal</option>
                                <option value="JA Mobile">JA Mobile</option>
                                <option value="JA Booking Phone">JA Booking Phone</option>
                                <option value="JA Global">JA Global</option>
                                <option value="Office Phone Number">Office Phone Number</option>
                                <option value="Bookings Phone Number">Bookings Phone Number</option>
                            </select>
                            <button type="button" class="px-2 py-1 text-white bg-green-500 rounded-md add-local">+</button>
                        </div>
                    </div>
                </div>

            </div>
            <div class="flex items-center justify-between mt-6">
                <a href="{{ route('admin.users.index') }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                    Back to Users List
                </a>
                <button type="submit" class="px-4 py-2 text-white bg-indigo-600 rounded-md">
                    Update User
                </button>
            </div>
        </form>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Function to add new work email row
            document.querySelector('.add-work-email').addEventListener('click', function () {
                let container = document.getElementById('work-email-container');
                let newRow = document.createElement('div');
                newRow.classList.add('flex', 'items-center', 'space-x-4', 'work-email-row');
                newRow.innerHTML = `
                    <input type="email" name="work_email[]" class="block w-full mt-1 border-gray-300 rounded-md shadow-sm">
                    <button type="button" class="px-2 py-1 text-white bg-red-500 rounded-md remove-work-email">−</button>
                `;
                container.appendChild(newRow);
            });

            // Function to add new share email row
            document.querySelector('.add-share-email').addEventListener('click', function () {
                let container = document.getElementById('share-email-container');
                let newRow = document.createElement('div');
                newRow.classList.add('flex', 'items-center', 'space-x-4', 'share-email-row');
                newRow.innerHTML = `
                    <input type="email" name="share_email[]" class="block w-full mt-1 border-gray-300 rounded-md shadow-sm">
                    <button type="button" class="px-2 py-1 text-white bg-red-500 rounded-md remove-share-email">−</button>
                `;
                container.appendChild(newRow);
            });

            // Function to remove email row
            document.addEventListener('click', function (event) {
                if (event.target.classList.contains('remove-work-email')) {
                    event.target.parentElement.remove();
                }
                if (event.target.classList.contains('remove-share-email')) {
                    event.target.parentElement.remove();
                }
            });
        });

        document.addEventListener("DOMContentLoaded", function () {
    function addRow(containerId, rowClass, nameField, selectField) {
        let container = document.getElementById(containerId);
        let newRow = document.createElement("div");
        newRow.classList.add("flex", "items-center", "space-x-4", rowClass);
        newRow.innerHTML = `
            <input type="text" name="${nameField}" class="w-full mt-1 border-gray-300 rounded-md shadow-sm">
            <select name="${selectField}" class="mt-1 border-gray-300 rounded-md shadow-sm">
                <option value="Personal">Personal</option>
                <option value="JA Mobile">JA Mobile</option>
                <option value="JA Booking Phone">JA Booking Phone</option>
                <option value="JA Global">JA Global</option>
                <option value="Office Phone Number">Office Phone Number</option>
                <option value="Bookings Phone Number">Bookings Phone Number</option>
            </select>
            <button type="button" class="px-2 py-1 text-white bg-red-500 rounded-md remove-row">−</button>
        `;
        container.appendChild(newRow);

        // Add event listener to remove button
        newRow.querySelector(".remove-row").addEventListener("click", function () {
            newRow.remove();
        });
    }

    // Phone Number - Add Row
    document.querySelector(".add-phone").addEventListener("click", function () {
        addRow("phone-number-container", "phone-number-row", "phone_number[]", "phone_number_type[]");
    });

        // Local Number - Add Row
        document.querySelector(".add-local").addEventListener("click", function () {
            addRow("local-number-container", "local-number-row", "local_number[]", "local_number_type[]");
        });

        // Handle Remove Buttons for Existing Elements
        document.querySelectorAll(".remove-phone").forEach(button => {
            button.addEventListener("click", function () {
                this.parentElement.remove();
            });
        });

        document.querySelectorAll(".remove-local").forEach(button => {
            button.addEventListener("click", function () {
                this.parentElement.remove();
            });
        });
    });

        </script>
</x-admin-layout>

