<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Users List</h1>
    </x-slot>
    <x-message type="success" message="success" />
    <x-message type="danger" message="error" />

    <div class="mb-4 flex justify-between items-center">
        <div>
                <a href="{{ route('admin.users.enabled') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest uppercase border border-transparent rounded-md shadow-sm
                    {{ request()->routeIs('admin.users.disabled') ? 'bg-gray-300 text-black hover:bg-gray-400' : 'bg-blue-600 text-white hover:bg-blue-700' }}">
                    View Enabled Users
                </a>
                <a href="{{ route('admin.users.disabled') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest uppercase border border-transparent rounded-md shadow-sm
                    {{ request()->routeIs('admin.users.disabled') ? 'bg-gray-600 text-white hover:bg-gray-700' : 'bg-gray-300 text-black hover:bg-gray-400' }}">
                    View Disabled Users
                </a>
        </div>
        <div>
            <a href="{{ route('admin.users.trashed') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-red-600 rounded-md shadow-sm hover:bg-red-700">
                View Trashed Users
            </a>
        </div>
    </div>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <!-- Desktop View -->
        <div class="hidden md:block">
            @can('user-add')
            <div class="flex items-center justify-between mb-4">
                <a id="addUserButton" href="{{ route('admin.users.create') }}" class="inline-flex items-center px-4 py-2 text-xs font-semibold tracking-widest text-white uppercase bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                    Add New User
                </a>
            </div>
           @endcan
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-800">
                    <tr>
                        <th class="px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Name</th>
                        <th class="px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Email</th>
                        <th class="px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Roles</th>
                        <th class="px-6 py-3 text-xs font-medium tracking-wider text-left text-gray-500 uppercase dark:text-gray-400">Actions</th>
                    </tr>
                </thead>
                <tbody id="userTable" class="bg-white divide-y divide-gray-200 dark:bg-gray-900 dark:divide-gray-700">
                    @forelse($users as $user)
                    <tr data-status="{{ $user->status ? 'enabled' : 'disabled' }}">
                            <td class="px-6 py-4 text-sm font-medium text-gray-900 whitespace-nowrap dark:text-gray-100">{{ $user->name }}</td>
                            <td class="px-6 py-4 text-sm text-gray-500 whitespace-nowrap dark:text-gray-400">{{ $user->email }}</td>
                            <td class="px-6 py-4 text-sm text-gray-500 whitespace-nowrap dark:text-gray-400">
                                @foreach($user->roles as $role)
                                    <span class="inline-block px-2 py-1 text-xs font-semibold text-gray-700 bg-gray-200 rounded-full dark:bg-gray-700 dark:text-gray-300">
                                        {{ $role->name }}
                                    </span>
                                @endforeach
                            </td>
                            <td class="px-6 py-4 text-sm font-medium whitespace-nowrap">
                                <a href="{{ route('admin.users.show', $user) }}" class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-300">View</a>
                                @if($user->status)
                                    @can('user-edit')
                                    <a href="{{ route('admin.users.edit', $user) }}" class="ml-4 text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-300">Edit</a>
                                    @endcan
                                    @can('user-delete')
                                    <button type="button" class="inline ml-4 text-red-600 dark:text-red-400 hover:text-red-900 dark:hover:text-red-300" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $user->id }}">
                                        Delete
                                    </button>
                                    <!-- Delete Modal Component -->
                                    <x-delete-modal :type="'User'" :id="$user->id" :name="$user->name" route="admin.users.destroy" />
                                    @endcan
                                @endif
                                @can('user-edit')
                                <button type="button" class="ml-4 px-3 py-1 text-white text-xs font-semibold rounded-md {{ $user->status ? 'bg-green-500 hover:bg-green-600' : 'bg-gray-500 hover:bg-gray-600' }}" data-bs-toggle="modal" data-bs-target="#statusModal{{ $user->id }}">
                                    {{ $user->status ? 'Enable' : 'Disable' }}
                                </button>
                                <!-- Status Modal Component -->
                                <x-status-modal :type="$user->status ? 'Disable' : 'Enable'" :id="$user->id" :name="$user->name" route="admin.users.toggle-status" />
                                @endcan
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-6 py-4 text-center text-gray-500 dark:text-gray-400">
                                No users found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Mobile View -->
        <div class="block space-y-4 md:hidden">
            @forelse($users as $user)
                <div class="p-4 bg-white rounded-lg shadow-md dark:bg-gray-800">
                    <div class="flex items-center justify-between mb-4">
                        <div class="text-lg font-semibold text-gray-900 dark:text-gray-100">{{ $user->name }}</div>
                        <div class="text-sm text-gray-500 dark:text-gray-400">{{ $user->email }}</div>
                    </div>
                    <div class="mb-4">
                        @foreach($user->roles as $role)
                            <span class="inline-block px-2 py-1 text-xs font-semibold text-gray-700 bg-gray-200 rounded-full dark:bg-gray-700 dark:text-gray-300">
                                {{ $role->name }}
                            </span>
                        @endforeach
                    </div>
                    <div class="flex space-x-4">
                        <a href="{{ route('admin.users.show', $user) }}" class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-300">View</a>
                        <a href="{{ route('admin.users.edit', $user) }}" class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-900 dark:hover:text-indigo-300">Edit</a>
                        <form action="{{ route('admin.users.destroy', $user) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 dark:text-red-400 hover:text-red-900 dark:hover:text-red-300">Delete</button>
                        </form>
                    </div>
                </div>
            @empty
                <div class="p-4 text-center text-gray-500 bg-white rounded-lg shadow-md dark:bg-gray-800 dark:text-gray-400">
                    No users found.
                </div>
            @endforelse
        </div>
    </div>
</x-admin-layout>
