<x-admin-layout>
    <x-slot name="header">
        <h1 class="text-2xl font-bold">Trashed Users</h1>
    </x-slot>

    <div class="p-6 bg-white rounded-lg shadow-md dark:bg-gray-800">
        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
            <thead class="bg-gray-50 dark:bg-gray-800">
                <tr>
                    <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase dark:text-gray-400">Name</th>
                    <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase dark:text-gray-400">Email</th>
                    {{-- <th class="px-6 py-3 text-xs font-medium text-gray-500 uppercase dark:text-gray-400">Actions</th> --}}
                </tr>
            </thead>
            <tbody>
                @forelse($users as $user)
                <tr>
                    <td class="px-6 py-4 text-sm text-gray-900 dark:text-gray-100">{{ $user->name }}</td>
                    <td class="px-6 py-4 text-sm text-gray-500 dark:text-gray-400">{{ $user->email }}</td>
                    {{-- <td class="px-6 py-4 text-sm">
                        <form action="{{ route('admin.users.restore', $user->id) }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="text-green-600 dark:text-green-400 hover:text-green-900">Restore</button>
                        </form>
                        <form action="{{ route('admin.users.force-delete', $user->id) }}" method="POST" class="inline ml-4">
                            @csrf
                            <button type="submit" class="text-red-600 dark:text-red-400 hover:text-red-900">Delete Permanently</button>
                        </form>
                    </td> --}}
                </tr>
                @empty
                <tr>
                    <td colspan="3" class="px-6 py-4 text-center text-gray-500 dark:text-gray-400">No trashed users found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</x-admin-layout>
