@props(['type', 'message'])

@if(session($message))
    <div id="alert-message" class="mb-2 alert alert-dismissible fade show d-inline-block" role="alert"
        style="background-color: {{ $type == 'success' ? '#d4edda' : '#f8d7da' }};
               color: {{ $type == 'success' ? '#155724' : '#721c24' }};
               padding: 10px 20px;
               border-radius: 5px;
               max-width: 90%;
               white-space: nowrap;
               overflow: hidden;
               text-overflow: ellipsis;">

        {{ session($message) }}
    </div>

    <script>
        setTimeout(() => {
            let alertBox = document.getElementById('alert-message');
            if (alertBox) {
                alertBox.style.transition = "opacity 0.5s";
                alertBox.style.opacity = "0";
                setTimeout(() => alertBox.remove(), 500);
            }
        }, 3000);
    </script>
@endif
