<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Thank You for Your Application</title>
</head>
<body style="font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 20px;">
    <div style="max-width: 600px; margin: auto; background: #ffffff; padding: 20px; border-radius: 8px;">
        <h2 style="color: #333; text-align: center;">Thank You for Applying to Be a Tour Guide with Japan Awaits</h2>
        <p>Dear <strong>{{ $details['first_name'] }} {{ $details['last_name'] }}</strong>,</p>
        <p>Your application has been received, and we will be reviewing it shortly. If you have any questions, you can contact us at <a href="mailto:guides@japanawaits.com">guides@japanawaits.com</a>.</p>

        <h3 style="color: #555; text-align: center;">Application Details</h3>
        <table style="width: 100%; border-collapse: collapse;">
            <tbody>
                @php $i = 0; @endphp
                @foreach([
                    'Which region do you live in?' => $details['region'],
                    'Which Prefecture do you live in?' => $details['prefecture'],
                    'Which City/Town/Village do you live in?' => $details['city'],
                    'Which station do you live closest to?' => $details['station'],
                    'What is your first name in English?' => $details['first_name'],
                    'What is your last name in English?' => $details['last_name'],
                    'What is your full name in Japanese?' => $details['japanese_name'],
                    'What is your email address?' => $details['email'],
                    'What is your contact phone number?' => $details['phone'],
                    'What is your date of birth?' => $details['dob'],
                    'What is your gender?' => $details['gender'],
                    'Do you have the National Government Guide Interpreter License?' => $details['interpreter_license'],
                    'What is your National Government Licensed Guide Interpreter License Number?' => $details['license_number'],
                    'What other certifications or licenses do you have that can support you in this role?' => $details['certifications'],
                    'How fluent are you in speaking English?' => $details['english_fluency'],
                    'What other languages can you conduct a tour in?' => $details['languages'],
                    'What is your job experience?' => $details['job_experience'],
                    'How many years have you been practicing as a tour guide?' => $details['years_of_experience'].' years',
                    'How many tours have you conducted since you became a tour guide?' => $details['number_of_tours'],
                    'Which cities or areas would you like to be a tour guide for?' => $details['guide_areas'],
                    'Which types of tours would you like to be a tour guide for?' => is_array($details['type_of_tours']) ? implode(', ', $details['type_of_tours']) : implode(', ', json_decode($details['type_of_tours'], true)),
                    'What is your availability in the next few months?' => $details['availability'],
                    'How did you hear about Japan Awaits?' => $details['how_heard']
                ] as $question => $answer)
                <tr style="background-color: {{ $i % 2 == 0 ? '#f4f4f4' : '#ffffff' }};">
                    <td style="padding: 10px; font-weight: bold; border: 1px solid #ddd;">{{ $question }}</td>
                    <td style="padding: 10px; border: 1px solid #ddd;">{{ $answer }}</td>
                </tr>
                @php $i++; @endphp
                @endforeach
            </tbody>
        </table>

        <p>We will reach out to you soon regarding the next steps. Thank you for your interest in working with us!</p>

        <p>Sincerely,</p>
        <p><strong>Japan Awaits Team</strong></p>
    </div>
</body>
</html>
