<!-- Email Modal -->
<div id="emailModal" class="hidden fixed inset-0 bg-gray-900 bg-opacity-50 flex items-center justify-center">
    <div class="bg-white p-5 rounded-lg shadow-lg w-3/5 max-h-[60vh] overflow-y-auto">
        <!-- Header -->
        <div class="flex justify-between items-center border-b pb-2">
            <h2 class="text-lg font-semibold">Mail Preview</h2>
            <button id="closeModal" class="text-gray-500 hover:text-gray-700 text-2xl">&times;</button>
        </div>

        <!-- Tabs -->
        <div class="flex border-b mt-3">
            <button id="emailTemplateTab" class="p-2 text-gray-700 font-medium border-b-2 border-transparent focus:border-orange-500">Email Template</button>
            <button id="previewTab" class="p-2 text-gray-700 font-medium border-b-2 border-transparent focus:border-orange-500">Preview</button>
        </div>

        <!-- Modal Content -->
        <div id="emailContent" class="mt-4">
            <!-- Template Selection -->
            <label class="block text-sm font-medium">Template</label>
            <input type="text" id="template" class="w-full p-2 border rounded-md mb-3" />

            <!-- Subject -->
            <label class="block text-sm font-medium">Subject</label>
            <input type="text" id="subject" class="w-full p-2 border rounded-md mb-3" />

            <!-- Mail Body -->
            <label class="block text-sm font-medium">Mail Body</label>
            <div class="border rounded-md p-2 mb-3">
                <button class="bg-gray-200 p-1 text-sm rounded">📎 Add Media</button>
                <textarea id="mailBody" class="w-full mt-2 p-2 border rounded-md h-40 overflow-y-auto"></textarea>
            </div>

            <!-- Email Input -->
            <label class="block text-sm font-medium">Email</label>
            <input type="email" id="email" class="w-full p-2 border rounded-md mb-3" />

            <!-- Schedule Email -->
            <div class="flex items-center space-x-2">
                <input type="checkbox" id="scheduleEmail" />
                <label for="scheduleEmail" class="text-sm">Schedule Email</label>
            </div>

            <!-- Buttons -->
            <div class="flex justify-between mt-4">
                <button id="sendMail" class="p-2 bg-green-600 text-white rounded-md shadow hover:bg-green-700">
                    Send Mail
                </button>
                <button id="sendAll" class="p-2 bg-green-600 text-white rounded-md shadow hover:bg-green-700">
                    Send All
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $("#sendEmail").click(function () {
            $("#emailModal").removeClass("hidden");
        });

        $("#closeModal").click(function () {
            $("#emailModal").addClass("hidden");
        });

        $("#sendMail, #sendAll").click(function () {
            alert("Email Sent Successfully!");
            $("#emailModal").addClass("hidden");
        });
    });
</script>
<?php /**PATH C:\xampp8.2\htdocs\Portal\resources\views/admin/tour_guide/email-modal.blade.php ENDPATH**/ ?>