<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tour Guide Application - Japan Awaits</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
</head>
<style>
    .select2-container--default .select2-selection--single {
        border: 1px solid #d1d5db;
        border-radius: 0.375rem;
        height: 38px;
        padding: 6px 12px;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
        color: #374151;
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 36px;
    }
</style>
<body class="bg-gray-100">

    <div class="max-w-4xl mx-auto mt-10 p-6 bg-white shadow-md rounded-lg">
        <h2 class="mb-4 text-2xl font-semibold text-center text-gray-800">Tour Guide Application for Japan Awaits</h2>
        
        <?php if (isset($component)) { $__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.auth-session-status','data' => ['class' => 'mb-4','status' => session('status')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('auth-session-status'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mb-4','status' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('status'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5)): ?>
<?php $attributes = $__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5; ?>
<?php unset($__attributesOriginal7c1bf3a9346f208f66ee83b06b607fb5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5)): ?>
<?php $component = $__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5; ?>
<?php unset($__componentOriginal7c1bf3a9346f208f66ee83b06b607fb5); ?>
<?php endif; ?>
        <form action="<?php echo e(route('tour-guide-application.store')); ?>" method="POST" class="mt-6">
            <?php echo csrf_field(); ?>
            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">Which region do you live in? <span class="text-red-500">*</span></label>
                <select id="region_id" name="region_id" class="select2 w-full p-3 border border-gray-300 rounded-lg">
                    <option value="">Select Region</option>
                    <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($region->id); ?>">
                            <?php echo e($region->eng_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php $__errorArgs = ['region_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">Which Prefecture do you live in? <span class="text-red-500">*</span></label>
                <select id="prefecture_id" name="prefecture_id" class="select2 w-full p-3 border border-gray-300 rounded-lg">
                    <option value="">Select Prefecture</option>
                </select>
                <?php $__errorArgs = ['prefecture_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">Which City/Town/Village do you live in? <span class="text-red-500">*</span></label>
                <select id="city_id" name="city_id" class="select2 w-full p-3 border border-gray-300 rounded-lg">
                    <option value="">Select City</option>
                </select>
                <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">Which station do you live closest to? <span class="text-red-500">*</span></label>
                <input type="text" name="station" class="w-full p-3 border border-gray-300 rounded-lg" required>
                <?php $__errorArgs = ['station'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">What is your full name in English? <span class="text-red-500">*</span></label>
                <div class="flex space-x-4">
                    <input type="text" name="first_name" placeholder="First Name" class="w-1/2 p-3 border border-gray-300 rounded-lg" required>
                    <input type="text" name="last_name" placeholder="Last Name" class="w-1/2 p-3 border border-gray-300 rounded-lg" required>
                    <?php $__errorArgs = [['first_name', 'last_name']];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">What is your full name in Japanese? <span class="text-red-500">*</span></label>
                <input type="text" name="japanese_name" class="w-full p-3 border border-gray-300 rounded-lg" required>
                <?php $__errorArgs = ['japanese_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">What is your email address? <span class="text-red-500">*</span></label>
                <input type="email" name="email" class="w-full p-3 border border-gray-300 rounded-lg" required>
                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">What is your contact phone number? <span class="text-red-500">*</span></label>
                <input type="tel" name="phone" class="w-full p-3 border border-gray-300 rounded-lg" required>
                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">What is your date of birth? <span class="text-red-500">*</span></label>
                <input type="date" name="dob" class="w-full p-3 border border-gray-300 rounded-lg" required>
                <?php $__errorArgs = ['dob'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">What is your gender? <span class="text-red-500">*</span></label>
                <div class="space-y-2">
                    <label class="flex items-center">
                        <input type="radio" name="gender" value="Male" class="mr-2" onclick="toggleOtherInput(false)">
                        Male
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="gender" value="Female" class="mr-2" onclick="toggleOtherInput(false)">
                        Female
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="gender" value="Other" class="mr-2" onclick="toggleOtherInput(true)">
                        Other
                    </label>
                    <input type="text" name="other_gender" id="otherGenderInput" class="w-full p-2 border border-gray-300 rounded-lg mt-2 hidden" placeholder="Please type here if you choose 'Other'">
                </div>
                <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <hr class="mb-4">

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">
                    Do you have the National Government Guide Interpreter License (通訳案内士登録証)? <span class="text-red-500">*</span>
                </label>
                <p class="text-sm text-gray-600 mb-2">
                    The National Government Guide Interpreter License (通訳案内士登録証) exam is administered by JNTO.
                </p>

                <div class="space-y-2">
                    <label class="flex items-center">
                        <input type="radio" name="interpreter_license" value="Yes" class="mr-2" onclick="toggleLicenseInput(true)"> Yes
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="interpreter_license" value="No" class="mr-2" onclick="toggleLicenseInput(false)"> No
                    </label>
                </div>

                <!-- Hidden input field for license number -->
                <div id="licenseInput" class="mt-3 hidden">
                    <label class="block text-gray-700 font-medium mb-2">
                        What is your National Government Licensed Guide Interpreter License Number (全国通訳案内士登録証記載の登録番号)? <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="license_number" class="w-full p-3 border border-gray-300 rounded-lg" placeholder="Enter your license number">
                </div>

                <?php $__errorArgs = ['interpreter_license'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <hr class="mb-4">

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">What other certifications or licenses do you have that can support you in this role?</label>
                <textarea name="certifications" class="w-full p-3 border border-gray-300 rounded-lg"></textarea>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">How fluent are you in speaking English? <span class="text-red-500">*</span></label>
                <div class="space-y-2">
                    <label class="flex items-center">
                        <input type="radio" name="english_fluency" value="1" class="mr-2">
                        1 (Not Fluent)
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="english_fluency" value="2" class="mr-2">
                        2
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="english_fluency" value="3" class="mr-2">
                        3
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="english_fluency" value="4" class="mr-2">
                        4
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="english_fluency" value="5" class="mr-2">
                        5 (Extremely Fluent)
                    </label>
                </div>
                <?php $__errorArgs = ['english_fluency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <hr class="mb-4">

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">What other languages can you conduct a tour in?</label>
                <select id="other_languages" name="other_languages[]" multiple  class="select2 w-full p-3 border border-gray-300 rounded-lg">
                    <option value="">Please select an option</option>
                    <?php $__currentLoopData = $other_languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other_language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($other_language->id); ?>">
                            <?php echo e($other_language->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">What is your job experience? <span class="text-red-500">*</span></label>
                <input type="text" name="job_experience" class="w-full p-3 border border-gray-300 rounded-lg">
                <?php $__errorArgs = ['job_experience'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">How many years have you been conducting tours as a tour guide for? <span class="text-red-500">*</span></label>
                <div class="space-y-2">
                    <label class="flex items-center">
                        <input type="radio" name="years_of_experience" value="<1 year" class="mr-2">
                        Less than 1 year
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="years_of_experience" value="2" class="mr-2">
                        2 years
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="years_of_experience" value="3" class="mr-2">
                        3 years
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="years_of_experience" value="4" class="mr-2">
                        4 years
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="years_of_experience" value="5" class="mr-2">
                        5 years
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="years_of_experience" value="6" class="mr-2">
                        6 years
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="years_of_experience" value="7" class="mr-2">
                        7 years
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="years_of_experience" value="8" class="mr-2">
                        8 years
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="years_of_experience" value="9" class="mr-2">
                        9 years
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="years_of_experience" value="10+" class="mr-2">
                        10+ years
                    </label>
                </div>
                <?php $__errorArgs = ['years_of_experience'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <hr class="mb-4">

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">How many tours have you conducted since you became a tour guide? <span class="text-red-500">*</span></label>
                <div class="space-y-2">
                    <label class="flex items-center">
                        <input type="radio" name="number_of_tours" value="1-50" class="mr-2">
                        1 to 50 tours
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="number_of_tours" value="51-100" class="mr-2">
                        51 to 100 tours
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="number_of_tours" value="101-200" class="mr-2">
                        101 to 200 tours
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="number_of_tours" value="201-300" class="mr-2">
                        201 to 300 tours
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="number_of_tours" value="301-400" class="mr-2">
                        301 to 400 tours
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="number_of_tours" value="401-500" class="mr-2">
                        401 to 500 tours
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="number_of_tours" value="500+" class="mr-2">
                        500+ tours
                    </label>
                </div>
                <?php $__errorArgs = ['number_of_tours'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <hr class="mb-4">

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">Which cities or areas would you like to be a tour guide for? <span class="text-red-500">*</span></label>
                <div id="guide-areas">
                    <div class="flex space-x-4 mb-2 area-group">
                        <select name="guide_areas[0][region]" id="region_id" class="select2 w-1/3 p-3 border border-gray-300 rounded-lg">
                            <option value="">Select Region</option>
                            <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($region->id); ?>"><?php echo e($region->eng_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <select name="guide_areas[0][prefecture]" id="prefecture_id" class="select2 w-1/3 p-3 border border-gray-300 rounded-lg">
                            <option value="">Select Prefecture</option>
                        </select>

                        <select name="guide_areas[0][cities][]" multiple id="city_id" class="select2 w-1/3 p-3 border border-gray-300 rounded-lg">
                            <option value="">Select City</option>
                        </select>

                        <button type="button" class="add-area bg-green-500 text-white px-3 py-1 rounded-lg">+</button>
                    </div>
                </div>
            </div>
            <hr class="mb-4">

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">Which types of tours would you like to be a tour guide for? <span class="text-red-500">*</span></label>
                <p class="text-sm text-gray-600 mb-2">Please select all that apply.</p>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-2">
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Active tours (hiking/ trekking, biking)" class="mr-2">
                        Active tours (hiking/ trekking, biking)
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Architecture tours" class="mr-2">
                        Architecture tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Beer and sake brewery tours" class="mr-2">
                        Beer and sake brewery tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Bus tours" class="mr-2">
                        Bus tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Cultural tours" class="mr-2">
                        Cultural tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Day trips" class="mr-2">
                        Day trips
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Food tours" class="mr-2">
                        Food tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Historical and heritage tours" class="mr-2">
                        Historical and heritage tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Large group tours (more than 9 people)" class="mr-2">
                        Large group tours (more than 9 people)
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Multi-day tours" class="mr-2">
                        Multi-day tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Pop-culture tours" class="mr-2">
                        Pop-culture tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Private tours" class="mr-2">
                        Private tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Sightseeing tours" class="mr-2">
                        Sightseeing tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Nightlife tours" class="mr-2">
                        Nightlife tours
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" name="type_of_tours[]" value="Small group tours (1 - 8 people)" class="mr-2">
                        Small group tours (1 - 8 people)
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" id="otherCheckbox" name="type_of_tours[]" value="Other" class="mr-2">
                        Other
                    </label>
                </div>

                <input type="text" id="otherInput" name="type_of_tours_other" placeholder="Please type here if you choose 'Other'" class="w-full mt-2 p-3 border border-gray-300 rounded-lg hidden">

                <?php $__errorArgs = ['type_of_tours'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <hr class="mb-4">

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">How did you hear about Japan Awaits? <span class="text-red-500">*</span></label>

                <div class="space-y-2">
                    <label class="flex items-center">
                        <input type="radio" name="how_heard" value="The Japan Awaits' team found my information and contacted me directly" class="mr-2">
                        The Japan Awaits' team found my information and contacted me directly
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="how_heard" value="I found Japan Awaits' website (japanawaits.com) or social media page" class="mr-2">
                        I found Japan Awaits' website (japanawaits.com) or social media page
                    </label>
                    <label class="flex items-center">
                        <input type="radio" id="referredCheckbox" name="how_heard" value="Someone I know referred me to Japan Awaits" class="mr-2">
                        Someone I know referred me to Japan Awaits
                    </label>
                    <input type="text" id="referredInput" name="referred_person" placeholder="Please tell us the person who referred you" class="w-full mt-2 p-3 border border-gray-300 rounded-lg hidden">

                    <label class="flex items-center">
                        <input type="radio" id="typeOftourOtherCheckbox" name="how_heard" value="Other" class="mr-2">
                        Other
                    </label>
                    <input type="text" id="typeOfTourOtherInput" name="how_heard_other" placeholder="Please tell us more about how you heard about Japan Awaits" class="w-full mt-2 p-3 border border-gray-300 rounded-lg hidden">
                </div>

                <?php $__errorArgs = ['how_heard'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <hr class="mb-4">

            <div class="mb-4">
                <label class="block text-gray-700 font-medium mb-2">What is your availability in the next few months? <span class="text-red-500">*</span></label>
                <input type="text" name="availability" class="w-full p-3 border border-gray-300 rounded-lg">
                <?php $__errorArgs = ['availability'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="flex justify-center">
                <button type="submit" class="bg-red-600 text-white py-2 px-6 rounded-lg hover:bg-red-700 transition duration-300">Submit</button>
            </div>
        </form>
    </div>

</body>
<script>
    $(document).ready(function() {
        $('.select2').select2({ width: '100%' });


       // Function to fetch prefectures based on region
       function fetchPrefectures(regionSelect, prefectureSelect, citySelect) {
            var regionId = regionSelect.val();
            prefectureSelect.html('<option value="">Select Prefecture</option>');
            citySelect.html('<option value="">Select City</option>');

            if (regionId) {
                $.ajax({
                    url: "<?php echo e(route('get.prefectures')); ?>?region_id=" + regionId,
                    type: "GET",
                    success: function(data) {
                        $.each(data, function(key, value) {
                            prefectureSelect.append('<option value="' + value.id + '">' + value.eng_name + '</option>');
                        });
                    }
                });
            }
        }

        // Function to fetch cities based on prefecture
        function fetchCities(prefectureSelect, citySelect) {
            var prefectureId = prefectureSelect.val();
            citySelect.html('<option value="">Select City</option>');

            if (prefectureId) {
                $.ajax({
                    url: "<?php echo e(route('get.cities')); ?>?prefecture_id=" + prefectureId,
                    type: "GET",
                    success: function(data) {
                        $.each(data, function(key, value) {
                            citySelect.append('<option value="' + value.id + '">' + value.eng_name + '</option>');
                        });
                    }
                });
            }
        }

        // Cascading Dropdowns for Main Address
        $('#region_id').change(function() {
            fetchPrefectures($(this), $('#prefecture_id'), $('#city_id'));
        });

        $('#prefecture_id').change(function() {
            fetchCities($(this), $('#city_id'));
        });

        $(document).on('change', '[name^="guide_areas"][name$="[region]"]', function() {
            var row = $(this).closest('.area-group');
            fetchPrefectures($(this), row.find('[name$="[prefecture]"]'), row.find('[name$="[cities][]"]'));
        });

        $(document).on('change', '[name^="guide_areas"][name$="[prefecture]"]', function() {
            var row = $(this).closest('.area-group');
            fetchCities($(this), row.find('[name$="[cities][]"]'));
        });

        // Add New Guide Area Selection Row
        $(document).on('click', '.add-area', function() {
            let index = $('.area-group').length; // New index based on existing areas

            let newRow = `
                <div class="flex space-x-4 mb-2 area-group">
                    <select name="guide_areas[${index}][region]" class="select2 w-1/3 p-3 border border-gray-300 rounded-lg">
                        <option value="">Select Region</option>
                        <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($region->id); ?>"><?php echo e($region->eng_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <select name="guide_areas[${index}][prefecture]" class="select2 w-1/3 p-3 border border-gray-300 rounded-lg">
                        <option value="">Select Prefecture</option>
                    </select>
                    <select name="guide_areas[${index}][cities][]" multiple class="select2 w-1/3 p-3 border border-gray-300 rounded-lg">
                        <option value="">Select City</option>
                    </select>
                    <button type="button" class="remove-area bg-red-500 text-white px-3 py-1 rounded-lg">-</button>
                </div>`;

            $('#guide-areas').append(newRow);
            $('.select2').select2({ width: '100%' });
        });

        // Remove Guide Area Selection Row
        $(document).on('click', '.remove-area', function() {
            $(this).closest('.area-group').remove();
        });

    });

    function toggleOtherInput(show) {
        const input = document.getElementById('otherGenderInput');
        if (show) {
            input.classList.remove('hidden');
            input.required = true;
        } else {
            input.classList.add('hidden');
            input.required = false;
            input.value = ''; // Clear input when not needed
        }
    }

    function toggleLicenseInput(show) {
        document.getElementById('licenseInput').classList.toggle('hidden', !show);
    }

    document.getElementById('otherCheckbox').addEventListener('change', function() {
        document.getElementById('otherInput').classList.toggle('hidden', !this.checked);
    });

    document.querySelectorAll('input[name="how_heard"]').forEach((radio) => {
        radio.addEventListener('change', function() {
            document.getElementById('referredInput').classList.toggle('hidden', this.value !== "Someone I know referred me to Japan Awaits");
            document.getElementById('typeOfTourOtherInput').classList.toggle('hidden', this.value !== "Other");
        });
    });

</script>
</html>
<?php /**PATH C:\xampp8.2\htdocs\Portal\resources\views/tour_guide_application.blade.php ENDPATH**/ ?>